/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.block.ArcaneCrystalObeliskBlock;
import com.stal111.forbidden_arcanus.common.block.ClibanoCenterBlock;
import com.stal111.forbidden_arcanus.common.block.ClibanoCornerBlock;
import com.stal111.forbidden_arcanus.common.block.ClibanoHorizontalSideBlock;
import com.stal111.forbidden_arcanus.common.block.ClibanoMainPartBlock;
import com.stal111.forbidden_arcanus.common.block.ClibanoPart;
import com.stal111.forbidden_arcanus.common.block.ClibanoVerticalSideBlock;
import com.stal111.forbidden_arcanus.common.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.block.ModBlockPatterns;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoMainBlockEntity;
import com.stal111.forbidden_arcanus.common.block.properties.ClibanoCenterType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.ObeliskPart;
import com.stal111.forbidden_arcanus.common.entity.CrimsonLightningBoltEntity;
import com.stal111.forbidden_arcanus.core.config.ItemConfig;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.valhelsia.valhelsia_core.common.util.ItemStackUtils;

public class MundabiturDustItem
extends Item {
    public MundabiturDustItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player;
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (this.tryTransformBlock(state, level, pos, player = context.m_43723_(), context.m_43719_())) {
            ItemStackUtils.shrinkStack((Player)player, (ItemStack)context.m_43722_());
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6225_(context);
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity target, @Nonnull InteractionHand hand) {
        SynchedEntityData dataManager;
        if (target instanceof Creeper && ((Boolean)ItemConfig.MUNDABITUR_DUST_CHARGE_CREEPER.get()).booleanValue() && !((Boolean)(dataManager = target.m_20088_()).m_135370_(Creeper.f_32274_)).booleanValue()) {
            dataManager.m_135381_(Creeper.f_32274_, (Object)true);
            ItemStackUtils.shrinkStack((Player)player, (ItemStack)stack);
            return InteractionResult.m_19078_((boolean)player.m_20193_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    private boolean tryTransformBlock(BlockState state, Level level, BlockPos pos, Player player, Direction clickedFace) {
        if (state.m_60713_(Blocks.f_50625_)) {
            BlockPattern.BlockPatternMatch patternHelper = ModBlockPatterns.HEPHAESTUS_PATTERN.m_61184_((LevelReader)level, pos);
            if (patternHelper == null) {
                return false;
            }
            level.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)level.m_8055_(pos)));
            level.m_46597_(pos, (BlockState)((HephaestusForgeBlock)((Object)ModBlocks.HEPHAESTUS_FORGE.get())).m_49966_().m_61124_((Property)ModBlockStateProperties.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            CrimsonLightningBoltEntity entity = new CrimsonLightningBoltEntity((EntityType<? extends LightningBolt>)((EntityType)ModEntities.CRIMSON_LIGHTNING_BOLT.get()), level);
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
            entity.m_20874_(true);
            level.m_7967_((Entity)entity);
            return true;
        }
        if (state.m_60713_((Block)ModBlocks.ARCANE_CRYSTAL_BLOCK.get()) || state.m_60713_((Block)ModBlocks.ARCANE_POLISHED_DARKSTONE.get())) {
            BlockPattern.BlockPatternMatch patternHelper = ModBlockPatterns.ARCANE_CRYSTAL_OBELISK_PATTERN.m_61184_((LevelReader)level, pos);
            if (patternHelper == null) {
                return false;
            }
            for (int i = 0; i < patternHelper.m_155970_(); ++i) {
                for (int j = 0; j < patternHelper.m_155971_(); ++j) {
                    BlockInWorld cachedBlockInfo = patternHelper.m_61229_(i, j, 0);
                    level.m_7731_(cachedBlockInfo.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    level.m_46796_(2001, cachedBlockInfo.m_61176_(), Block.m_49956_((BlockState)cachedBlockInfo.m_61168_()));
                }
            }
            BlockState obelisk = ((Block)ModBlocks.ARCANE_CRYSTAL_OBELISK.get()).m_49966_();
            BlockPos topPos = patternHelper.m_61228_();
            level.m_7731_(topPos.m_6625_(2), (BlockState)((BlockState)obelisk.m_61124_(ArcaneCrystalObeliskBlock.PART, (Comparable)((Object)ObeliskPart.LOWER))).m_61124_((Property)ModBlockStateProperties.RITUAL, (Comparable)Boolean.valueOf(((ArcaneCrystalObeliskBlock)obelisk.m_60734_()).isArcaneChiseledPolishedDarkstoneBelow(level, topPos.m_6625_(2)))), 2);
            level.m_7731_(topPos.m_6625_(1), (BlockState)obelisk.m_61124_(ArcaneCrystalObeliskBlock.PART, (Comparable)((Object)ObeliskPart.MIDDLE)), 2);
            level.m_7731_(topPos, (BlockState)obelisk.m_61124_(ArcaneCrystalObeliskBlock.PART, (Comparable)((Object)ObeliskPart.UPPER)), 2);
            return true;
        }
        if (state.m_60713_((Block)ModBlocks.CLIBANO_CORE.get())) {
            ServerLevel serverLevel;
            Direction[] directionArray;
            if (clickedFace.m_122434_() == Direction.Axis.Y) {
                return false;
            }
            BlockPattern.BlockPatternMatch patternHelper = ModBlockPatterns.CLIBANO_COMBUSTION_BASE.m_61184_((LevelReader)level, pos.m_7495_());
            if (patternHelper == null) {
                return false;
            }
            BlockPos bottomPos = pos.m_7495_().m_121945_(clickedFace.m_122427_());
            BlockState cornerState = ((ClibanoCornerBlock)ModBlocks.CLIBANO_CORNER.get()).m_49966_();
            this.placeClibanoBlock(level, bottomPos, (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace));
            this.placeClibanoBlock(level, bottomPos.m_5484_(clickedFace.m_122424_(), 2), (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace.m_122427_()));
            this.placeClibanoBlock(level, bottomPos.m_5484_(clickedFace.m_122424_(), 2).m_5484_(clickedFace.m_122428_(), 2), (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace.m_122424_()));
            this.placeClibanoBlock(level, bottomPos.m_5484_(clickedFace.m_122428_(), 2), (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace.m_122428_()));
            BlockPos topPos = pos.m_7494_().m_121945_(clickedFace.m_122427_());
            cornerState = (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61427_, (Comparable)Boolean.valueOf(false));
            this.placeClibanoBlock(level, topPos, (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace));
            this.placeClibanoBlock(level, topPos.m_5484_(clickedFace.m_122424_(), 2), (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace.m_122427_()));
            this.placeClibanoBlock(level, topPos.m_5484_(clickedFace.m_122424_(), 2).m_5484_(clickedFace.m_122428_(), 2), (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace.m_122424_()));
            this.placeClibanoBlock(level, topPos.m_5484_(clickedFace.m_122428_(), 2), (BlockState)cornerState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace.m_122428_()));
            BlockPos centerPos = pos.m_121945_(clickedFace.m_122424_());
            BlockState centerState = ((ClibanoCenterBlock)ModBlocks.CLIBANO_CENTER.get()).m_49966_();
            BlockState horizontalSideState = ((ClibanoHorizontalSideBlock)ModBlocks.CLIBANO_SIDE_HORIZONTAL.get()).m_49966_();
            BlockState verticalSideState = ((ClibanoVerticalSideBlock)ModBlocks.CLIBANO_SIDE_VERTICAL.get()).m_49966_();
            for (Direction direction : Direction.values()) {
                BlockPos relativePos = centerPos.m_121945_(direction);
                this.placeClibanoBlock(level, relativePos, (BlockState)((BlockState)centerState.m_61124_(ModBlockStateProperties.CLIBANO_CENTER_TYPE, (Comparable)((Object)ClibanoCenterType.getFromDirection(direction, clickedFace)))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction));
                if (direction.m_122434_() == Direction.Axis.Y) continue;
                this.placeClibanoBlock(level, relativePos.m_121945_(direction.m_122427_()), (BlockState)((BlockState)horizontalSideState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction)).m_61124_((Property)ModBlockStateProperties.MIRRORED, (Comparable)Boolean.valueOf(direction == clickedFace.m_122428_())));
                this.placeClibanoBlock(level, relativePos.m_121945_(Direction.UP), (BlockState)((BlockState)verticalSideState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction)).m_61124_((Property)BlockStateProperties.f_61427_, (Comparable)Boolean.valueOf(false)));
                this.placeClibanoBlock(level, relativePos.m_121945_(Direction.DOWN), (BlockState)verticalSideState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction));
            }
            level.m_7731_(centerPos, ((ClibanoMainPartBlock)((Object)ModBlocks.CLIBANO_MAIN_PART.get())).m_49966_(), 2);
            if (level instanceof ServerLevel && (directionArray = (serverLevel = (ServerLevel)level).m_7702_(centerPos)) instanceof ClibanoMainBlockEntity) {
                ClibanoMainBlockEntity blockEntity = (ClibanoMainBlockEntity)directionArray;
                blockEntity.setFrontDirection(clickedFace);
                for (Direction direction : Direction.values()) {
                    BlockEntity blockEntity2 = serverLevel.m_7702_(centerPos.m_121945_(direction));
                    if (!(blockEntity2 instanceof ClibanoBlockEntity)) continue;
                    ClibanoBlockEntity clibanoBlockEntity = (ClibanoBlockEntity)blockEntity2;
                    clibanoBlockEntity.setMainDirection(direction.m_122424_());
                }
            }
            return true;
        }
        return false;
    }

    private void placeClibanoBlock(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        BlockState oldState = level.m_8055_(pos);
        level.m_7731_(pos, state, 2);
        if (state.m_60734_() instanceof ClibanoPart && (blockEntity = level.m_7702_(pos)) instanceof ClibanoBlockEntity) {
            ClibanoBlockEntity blockEntity2 = (ClibanoBlockEntity)blockEntity;
            blockEntity2.setReplaceState(oldState);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)oldState));
        }
    }
}

