/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.lostsoul;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Dynamic;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.LostSoulAi;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.SoulExtractable;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModMemoryModules;
import com.stal111.forbidden_arcanus.core.init.other.ModActivities;
import com.stal111.forbidden_arcanus.core.init.other.ModDamageSources;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class LostSoul
extends PathfinderMob
implements SoulExtractable {
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_217766_, (Object)MemoryModuleType.f_217768_, (Object)((MemoryModuleType)ModMemoryModules.SCARED_TIME.get()));
    protected static final ImmutableList<SensorType<? extends Sensor<? super LostSoul>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_217824_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(LostSoul.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DATA_SCARED = SynchedEntityData.m_135353_(LostSoul.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final double ENCHANTED_CHANCE = 0.04;
    public static final double ENTITY_DEATH_SPAWN_CHANCE = 0.05;
    private static final int EXTRACT_STUNNED_TIME = 30;
    private static final float EXTRACT_DAMAGE = 2.0f;
    private int extractCounter = 0;
    public final AnimationState stillAnimationState = new AnimationState();
    public final AnimationState fearAnimationState = new AnimationState();

    public LostSoul(Level level, double x, double y, double z) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.LOST_SOUL.get()), level);
        this.m_6034_(x, y, z);
    }

    public LostSoul(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.BLOCKED, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 15, true);
        this.f_19794_ = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22279_, 0.3);
    }

    public static boolean canSpawn(EntityType<LostSoul> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return true;
    }

    protected void m_6475_(@Nonnull DamageSource source, float amount) {
        if (source.m_19385_().equals("forbidden_arcanus:extractSoul") || source == DamageSource.f_19317_) {
            super.m_6475_(source, amount);
        }
    }

    public void m_147240_(double strength, double x, double z) {
    }

    @Nonnull
    protected Brain.Provider<LostSoul> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Nonnull
    protected Brain<?> m_8075_(@Nonnull Dynamic<?> dynamic) {
        return LostSoulAi.makeBrain((Brain<LostSoul>)this.m_5490_().m_22073_(dynamic));
    }

    @Nonnull
    public Brain<LostSoul> m_6274_() {
        return super.m_6274_();
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        boolean enchanted;
        boolean bl = enchanted = this.f_19796_.m_188500_() < 0.04;
        if (enchanted) {
            this.setVariant(Variant.ENCHANTED_LOST_SOUL);
        } else if (level.m_204166_(this.m_20183_()).m_203656_(ModTags.Biomes.SPAWNS_CORRUPT_LOST_SOUL)) {
            this.setVariant(Variant.CORRUPT_LOST_SOUL);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public float m_5610_(@Nonnull BlockPos pos, @Nonnull LevelReader level) {
        return level.m_8055_(pos).m_60795_() ? 35.0f : 0.0f;
    }

    @Nonnull
    protected PathNavigation m_6037_(@Nonnull Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_SCARED, (Object)false);
    }

    public void m_8119_() {
        if (!this.f_19853_.m_5776_()) {
            boolean isPanicking = this.f_20939_.m_21952_(MemoryModuleType.f_217768_).orElse(false);
            boolean isScared = this.m_6274_().m_21876_((MemoryModuleType)ModMemoryModules.SCARED_TIME.get(), MemoryStatus.VALUE_PRESENT);
            if (this.extractCounter != 0) {
                --this.extractCounter;
            }
            if (this.m_6274_().m_21874_(MemoryModuleType.f_26382_) && !this.isScared()) {
                this.f_19804_.m_135381_(DATA_SCARED, (Object)true);
                this.m_21441_(BlockPathTypes.BLOCKED, 0.0f);
                this.m_6274_().m_21889_(Activity.f_37984_);
            }
        } else if (this.f_19853_.m_46467_() % 10L == 0L) {
            Vec3 viewVector = this.m_20171_(this.m_146909_(), this.m_146908_());
            this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(this.getVariant().getTrailColor(), 1.0f), this.m_20185_() - viewVector.f_82479_ * 0.5, this.m_20186_() + 0.2, this.m_20189_() - viewVector.f_82481_ * 0.5, 0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7840_(double y, boolean onGround, @Nonnull BlockState state, @Nonnull BlockPos pos) {
    }

    public boolean m_142535_(float fallDistance, float multiplier, @Nonnull DamageSource source) {
        return false;
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> key) {
        if (key.equals(DATA_SCARED)) {
            if (this.isScared()) {
                this.fearAnimationState.m_216982_(this.f_19797_);
                this.stillAnimationState.m_216973_();
            } else {
                this.stillAnimationState.m_216982_(this.f_19797_);
                this.fearAnimationState.m_216973_();
            }
        }
        super.m_7350_(key);
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("lostSoulBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().getId());
        tag.m_128379_("Scared", ((Boolean)this.f_19804_.m_135370_(DATA_SCARED)).booleanValue());
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.FROM_ID.apply(tag.m_128451_("Variant")));
        this.f_19804_.m_135381_(DATA_SCARED, (Object)tag.m_128471_("Scared"));
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Variant variant = this.getVariant();
        if (variant != Variant.CORRUPT_LOST_SOUL && stack.m_150930_((Item)ModItems.CORRUPTI_DUST.get())) {
            this.setVariant(Variant.CORRUPT_LOST_SOUL);
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        if (variant == Variant.CORRUPT_LOST_SOUL && stack.m_150930_((Item)ModItems.AUREAL_BOTTLE.get())) {
            this.setVariant(Variant.LOST_SOUL);
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        if (variant == Variant.LOST_SOUL && stack.m_150930_((Item)ModItems.AUREAL_BOTTLE.get())) {
            this.setVariant(Variant.ENCHANTED_LOST_SOUL);
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public Variant getVariant() {
        return Variant.FROM_ID.apply((Integer)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getId());
    }

    public boolean isScared() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SCARED);
    }

    @Override
    public ItemStack getSoulItem() {
        return new ItemStack((ItemLike)this.getVariant().getSoulItem());
    }

    @Override
    public void setExtracting() {
        if (!this.m_6274_().m_147340_().contains(ModActivities.SOUL_EXTRACTING.get())) {
            this.m_6274_().m_21889_((Activity)ModActivities.SOUL_EXTRACTING.get());
        }
    }

    @Override
    public void extractTick(Player player) {
        this.extractCounter = 30;
        this.m_6469_(ModDamageSources.extractSoul(player), 2.0f);
        if (this.m_21224_()) {
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getSoulItem()));
        }
    }

    public boolean isExtracting() {
        return this.extractCounter > 0;
    }

    public static enum Variant {
        LOST_SOUL(0, "lost_soul", (Item)ModItems.SOUL.get(), 15001592),
        CORRUPT_LOST_SOUL(1, "corrupt_lost_soul", (Item)ModItems.CORRUPT_SOUL.get(), 4477845),
        ENCHANTED_LOST_SOUL(2, "enchanted_lost_soul", (Item)ModItems.ENCHANTED_SOUL.get(), 16638446);

        public static final Function<Integer, Variant> FROM_ID;
        private final int id;
        private final String name;
        private final Item soulItem;
        private final Vector3f trailColor;

        private Variant(int id, String name, Item soulItem, int trailColor) {
            this.id = id;
            this.name = name;
            this.soulItem = soulItem;
            this.trailColor = new Vector3f(Vec3.m_82501_((int)trailColor));
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Item getSoulItem() {
            return this.soulItem;
        }

        public Vector3f getTrailColor() {
            return this.trailColor;
        }

        public ResourceLocation getTexture() {
            return new ResourceLocation("forbidden_arcanus", "textures/entity/lost_soul/" + this.name + ".png");
        }

        static {
            FROM_ID = integer -> Arrays.stream(Variant.values()).filter(variant -> variant.id == integer).findFirst().orElse(LOST_SOUL);
        }
    }
}

