/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import samebutdifferent.ecologics.entity.ModBoat;

public class ModBoatRenderer<T extends ModBoat>
extends EntityRenderer<T> {
    private final Map<ModBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources = Maps.newHashMap();

    public ModBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        for (ModBoat.Type type : ModBoat.Type.values()) {
            this.boatResources.put(type, (Pair<ResourceLocation, BoatModel>)Pair.of((Object)type.getTexture(hasChest), (Object)new BoatModel(context.m_174023_(new ModelLayerLocation(new ResourceLocation("ecologics", hasChest ? type.getChestModelLocation() : type.getModelLocation()), "main")), hasChest)));
        }
    }

    public void render(T boat, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float h;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.375, 0.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float f = (float)boat.m_38385_() - partialTicks;
        float g = boat.m_38384_() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * g / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(h = boat.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), boat.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.boatResources.get((Object)((ModBoat)((Object)boat)).getWoodType());
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        BoatModel boatModel = (BoatModel)pair.getSecond();
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatModel.m_6973_(boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(boatModel.m_103119_(resourceLocation));
        boatModel.m_7695_(matrixStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexConsumer2 = buffer.m_6299_(RenderType.m_110478_());
            boatModel.m_102282_().m_104301_(matrixStack, vertexConsumer2, packedLight, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        super.m_7392_(boat, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ModBoat boat) {
        return (ResourceLocation)this.boatResources.get((Object)boat.getWoodType()).getFirst();
    }
}

