/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.world.feature.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import teamrazor.deepaether.world.feature.features.configuration.FallenTreeConfiguration;
import teamrazor.deepaether.world.feature.tree.trunk.TrunkUtils;

public class FallenTreeFeature
extends Feature<FallenTreeConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FallenTreeConfiguration> context) {
        WorldGenLevel reader = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        FallenTreeConfiguration config = (FallenTreeConfiguration)context.m_159778_();
        BlockState block = config.block().m_213972_(context.m_225041_(), pos);
        int length = rand.m_216339_(config.min(), config.max());
        int gap = rand.m_216339_(2, 4);
        int MAX_DEPTH = 4;
        Direction direction = TrunkUtils.getRandomDirectionButNotOnTheYAxis(rand);
        if (!this.canPlace((LevelReader)reader, pos)) {
            return false;
        }
        if (this.canPlace((LevelReader)reader, (pos = pos.m_5484_(direction, gap)).m_7495_())) {
            return false;
        }
        boolean follow_terrain = rand.m_188499_();
        if (follow_terrain) {
            BlockPos tempPos = pos;
            for (i = 0; i < length; ++i) {
                if (this.canPlace((LevelReader)reader, tempPos.m_5484_(direction, i).m_7495_()) && this.canPlace((LevelReader)reader, tempPos.m_5484_(direction, i))) {
                    boolean f = false;
                    for (int ii = 1; ii < 4; ++ii) {
                        if (this.canPlace((LevelReader)reader, tempPos.m_5484_(direction, i).m_6625_(ii))) continue;
                        tempPos = tempPos.m_6625_(ii - 1);
                        f = true;
                    }
                    if (f) continue;
                    return false;
                }
                if (this.canPlace((LevelReader)reader, tempPos.m_5484_(direction, i))) continue;
                return false;
            }
        } else {
            int posWithoutBlockBelow = 0;
            for (i = 0; i < length; ++i) {
                if (!this.canPlace((LevelReader)reader, pos.m_5484_(direction, i))) {
                    return false;
                }
                posWithoutBlockBelow = this.canPlace((LevelReader)reader, pos.m_5484_(direction, i).m_7495_()) ? ++posWithoutBlockBelow : 0;
                if (posWithoutBlockBelow <= 2) continue;
                return false;
            }
        }
        this.m_5974_((LevelWriter)reader, pos.m_5484_(direction.m_122424_(), gap), block);
        if (follow_terrain) {
            for (int i = 0; i < length; ++i) {
                if (this.canPlace((LevelReader)reader, pos.m_5484_(direction, i).m_7495_())) {
                    for (int ii = 1; ii < 4; ++ii) {
                        if (this.canPlace((LevelReader)reader, pos.m_5484_(direction, i).m_6625_(ii))) continue;
                        pos = pos.m_6625_(ii - 1);
                    }
                }
                this.m_5974_((LevelWriter)reader, pos.m_5484_(direction, i), (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
                this.addDecorators(reader, pos, config.decorators().m_213972_(context.m_225041_(), pos), context.m_225041_(), direction);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.m_5974_((LevelWriter)reader, pos.m_5484_(direction, i), (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
                this.addDecorators(reader, pos, config.decorators().m_213972_(context.m_225041_(), pos), context.m_225041_(), direction);
            }
        }
        return true;
    }

    public boolean canPlace(LevelReader reader, BlockPos pos) {
        BlockState state = reader.m_8055_(pos);
        return reader.m_46859_(pos) || state.m_204336_(BlockTags.f_13035_) || !state.m_60838_((BlockGetter)reader, pos);
    }

    public void addDecorators(WorldGenLevel reader, BlockPos pos, BlockState block, RandomSource random, Direction direction) {
        if (random.m_188503_(7) == 1 && this.canPlace((LevelReader)reader, pos.m_7494_())) {
            this.m_5974_((LevelWriter)reader, pos.m_7494_(), block);
        }
        if (random.m_188503_(4) == 1 && this.canPlace((LevelReader)reader, pos.m_121945_(direction).m_7494_())) {
            this.m_5974_((LevelWriter)reader, pos.m_121945_(direction).m_7494_(), block);
        }
        if (random.m_188503_(7) == 1 && this.canPlace((LevelReader)reader, pos.m_121945_(direction.m_122427_())) && !this.canPlace((LevelReader)reader, pos.m_121945_(direction.m_122427_()).m_7495_())) {
            this.m_5974_((LevelWriter)reader, pos.m_121945_(direction.m_122427_()), block);
        }
        if (random.m_188503_(7) == 1 && this.canPlace((LevelReader)reader, pos.m_121945_(direction.m_122428_())) && !this.canPlace((LevelReader)reader, pos.m_121945_(direction.m_122428_()).m_7495_())) {
            this.m_5974_((LevelWriter)reader, pos.m_121945_(direction.m_122427_()), block);
        }
    }
}

