/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import teamrazor.deepaether.recipe.AbstractPoisonRecipe;

public class PoisonRecipeSerializer<T extends AbstractPoisonRecipe>
implements RecipeSerializer<T> {
    private final CookieBaker<T> factory;

    public PoisonRecipeSerializer(CookieBaker<T> factory) {
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        ItemStack result;
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        JsonArray ingredientJson = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientJson);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        } else {
            String resultString = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            ResourceLocation resultLocation = new ResourceLocation(resultString);
            result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resultLocation));
            if (result.m_41619_()) {
                throw new IllegalStateException("Item: " + resultString + " does not exist");
            }
        }
        return this.factory.create(id, group, ingredient, result);
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String group = buffer.m_130277_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        return this.factory.create(id, group, ingredient, result);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130070_(((AbstractPoisonRecipe)recipe).m_6076_());
        ((Ingredient)((AbstractPoisonRecipe)recipe).m_7527_().get(0)).m_43923_(buffer);
        buffer.m_130055_(((AbstractPoisonRecipe)recipe).getResult());
    }

    public static interface CookieBaker<T extends AbstractPoisonRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
    }
}

