/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.gear.stratus;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.capability.player.AetherPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import teamrazor.deepaether.client.keys.DeepAetherKeys;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.item.gear.DaArmorItem;
import teamrazor.deepaether.item.gear.EquipmentUtil;
import top.theillusivec4.curios.api.CuriosApi;

public class StratusAbility
extends DaArmorItem {
    static float coolDown = 0.0f;
    private final double strength = 1.3;
    private static boolean hasBeenOnGround = true;

    public StratusAbility(ArmorMaterial p_40386_, EquipmentSlot p_40387_, Item.Properties p_40388_) {
        super(p_40386_, p_40387_, p_40388_);
    }

    public static boolean hasFullStratusSet(LivingEntity entity) {
        return StratusAbility.hasArmorSet(entity, (Item)DAItems.STRATUS_HELMET.get(), (Item)DAItems.STRATUS_CHESTPLATE.get(), (Item)DAItems.STRATUS_LEGGINGS.get(), (Item)DAItems.STRATUS_BOOTS.get(), (Item)DAItems.STRATUS_GLOVES.get());
    }

    private static boolean hasArmorSet(LivingEntity entity, Item helmet, Item chestplate, Item leggings, Item boots, Item gloves) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_150930_(helmet) && entity.m_6844_(EquipmentSlot.CHEST).m_150930_(chestplate) && entity.m_6844_(EquipmentSlot.LEGS).m_150930_(leggings) && entity.m_6844_(EquipmentSlot.FEET).m_150930_(boots) && ((Boolean)AetherConfig.SERVER.require_gloves.get() == false || CuriosApi.getCuriosHelper().findFirstCurio(entity, gloves).isPresent());
    }

    private static boolean isStratusDashActive(Player player) {
        return StratusAbility.hasFullStratusSet((LivingEntity)player) && coolDown <= 0.0f;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (player.m_20096_()) {
            hasBeenOnGround = true;
        }
        if (coolDown >= 0.0f) {
            coolDown = (float)((double)coolDown - 0.02);
        }
        if (world.m_5776_() && StratusAbility.hasFullStratusSet((LivingEntity)player) && DeepAetherKeys.STRATUS_DASH_ABILITY.m_90857_()) {
            StratusAbility.dash((LivingEntity)player, 1.3);
        }
    }

    static void dash(LivingEntity entity, double strength) {
        if (EquipmentUtil.hasFullStratusSet(entity) && hasBeenOnGround && entity instanceof Player) {
            Player player = (Player)entity;
            double x = player.m_20154_().f_82479_ * strength * 2.0;
            double y = player.m_20154_().f_82480_ * strength;
            double z = player.m_20154_().f_82481_ * strength * 2.0;
            double a = y * 0.5;
            if (a < 0.0) {
                a *= -1.0;
            }
            a = 1.0 - a;
            if (StratusAbility.isStratusDashActive(player)) {
                hasBeenOnGround = false;
                coolDown = 5.0f;
                float dashMultiplier = (float)EquipmentUtil.handleStratusRingBoost((LivingEntity)player);
                player.m_5997_(x * a * (double)dashMultiplier, y * (double)dashMultiplier, z * a * (double)dashMultiplier);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            }
        }
    }

    public static void moreBoostedJump(LivingEntity entity) {
        if (EquipmentUtil.hasFullStratusSet(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AetherPlayer.get((Player)player).ifPresent(aetherPlayer -> {
                    if (aetherPlayer.isGravititeJumpActive()) {
                        player.m_5997_(0.0, 1.3 * (double)((float)EquipmentUtil.handleStratusRingBoost((LivingEntity)player)), 0.0);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                        }
                    }
                });
            } else {
                entity.m_5997_(0.0, 1.3, 0.0);
            }
        }
    }
}

