/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.gear.other;

import com.aetherteam.aether.item.accessories.ring.RingItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import teamrazor.deepaether.DeepAetherMod;
import teamrazor.deepaether.item.gear.EquipmentUtil;
import teamrazor.deepaether.mixin.AetherSkyRenderEffectsAccessor;
import top.theillusivec4.curios.api.SlotContext;

public class SpookyRing
extends RingItem {
    public static final UUID SPOOKY_RING_UUID = UUID.fromString("48934393-2a67-4bd1-b5bd-88c18538cee1");
    Multimap<Attribute, AttributeModifier> attributes = HashMultimap.create();

    public SpookyRing(Supplier<? extends SoundEvent> ringSound, Item.Properties properties) {
        super(ringSound, properties);
    }

    private int calculateIncrease(SlotContext context) {
        Level level = context.entity().m_9236_();
        int a = (int)level.m_46468_();
        if (level.m_46462_() && a < 13000) {
            return Mth.m_14040_((int)(a - 18000)) / 2000;
        }
        return 0;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        SpookyRing.SpookyMoonConditions(slotContext);
        AttributeModifier attribute = slotContext.entity().m_21051_(Attributes.f_22281_).m_22111_(SPOOKY_RING_UUID);
        if (attribute != null) {
            slotContext.entity().m_21051_(Attributes.f_22281_).m_22120_(SPOOKY_RING_UUID);
            this.attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(SPOOKY_RING_UUID, "Gloves Damage Bonus", (double)this.calculateIncrease(slotContext), AttributeModifier.Operation.ADDITION));
        } else {
            this.attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(SPOOKY_RING_UUID, "Gloves Damage Bonus", (double)this.calculateIncrease(slotContext), AttributeModifier.Operation.ADDITION));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        SpookyRing.SpookyMoonConditions(slotContext);
    }

    public static void SpookyMoonConditions(SlotContext slotContext) {
        Level level = slotContext.entity().m_9236_();
        if (level.m_5776_()) {
            LevelRenderer.f_109454_ = EquipmentUtil.hasTwoSpookyRings(slotContext) & level.m_46941_() == 0 && DeepAetherMod.IS_HALLOWEEN ? new ResourceLocation("deep_aether", "textures/environment/spooky_moon_phases.png") : new ResourceLocation("textures/environment/moon_phases.png");
            AetherSkyRenderEffectsAccessor.setMOON_LOCATION(EquipmentUtil.hasTwoSpookyRings(slotContext) && level.m_46941_() == 0 && DeepAetherMod.IS_HALLOWEEN ? new ResourceLocation("deep_aether", "textures/environment/spooky_moon_phases.png") : new ResourceLocation("textures/environment/moon_phases.png"));
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tagTooltips, ItemStack stack) {
        tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.spooky_ring").m_130940_(ChatFormatting.DARK_RED));
        return super.getAttributesTooltip(tagTooltips, stack);
    }
}

