/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity.quail;

import com.aetherteam.aether.entity.passive.AetherAnimal;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public abstract class SittingAetherAnimal
extends AetherAnimal {
    private static final EntityDataAccessor<Boolean> DATA_SITTING_ID = SynchedEntityData.m_135353_(SittingAetherAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int sitCounter;

    protected SittingAetherAnimal(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SITTING_ID, (Object)false);
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("IsBaby")) {
            this.m_6863_(tag.m_128471_("IsBaby"));
        }
        if (tag.m_128441_("Sitting")) {
            this.setSitting(tag.m_128471_("Sitting"));
        }
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Sitting", this.isSitting());
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SITTING_ID);
    }

    public void setSitting(boolean isSitting) {
        this.f_19804_.m_135381_(DATA_SITTING_ID, (Object)isSitting);
    }

    public void tryToSit() {
        if (!this.m_20072_() && this.m_20096_() && this.m_6142_()) {
            this.m_21564_(0.0f);
            this.m_21573_().m_26573_();
            this.setSitting(true);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6142_() && this.sitCounter > 0 && ++this.sitCounter > 20) {
            this.sitCounter = 0;
            this.setSitting(false);
        }
    }

    static class RandomSittingGoal
    extends Goal {
        private int cooldown;
        private final SittingAetherAnimal mob;

        public RandomSittingGoal(SittingAetherAnimal animal) {
            this.mob = animal;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.cooldown <= this.mob.f_19797_ && !this.mob.m_20069_();
        }

        public boolean m_8045_() {
            if (!this.mob.m_20069_() && this.mob.f_19796_.m_188503_(RandomSittingGoal.m_186073_((int)1000)) != 1) {
                return this.mob.f_19796_.m_188503_(RandomSittingGoal.m_186073_((int)2500)) != 1;
            }
            return false;
        }

        public void m_8037_() {
            if (!this.mob.isSitting()) {
                this.mob.tryToSit();
            }
        }

        public void m_8056_() {
            this.mob.tryToSit();
            this.cooldown = 0;
        }

        public void m_8041_() {
            int i = this.mob.f_19796_.m_188503_(150) + 10;
            this.cooldown = this.mob.f_19797_ + i * 20;
            this.mob.setSitting(false);
        }
    }
}

