/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import teamrazor.deepaether.entity.DABoatEntity;

public class DABoatRenderer<T extends DABoatEntity>
extends EntityRenderer<T> {
    private final Map<DABoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public DABoatRenderer(EntityRendererProvider.Context renderer, boolean hasChest) {
        super(renderer);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(DABoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)type.getTexture(hasChest), this.createBoatModel(renderer, (DABoatEntity.Type)((Object)type), hasChest))));
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context renderer, DABoatEntity.Type type, boolean hasChest) {
        ModelLayerLocation modelLayerLocation = hasChest ? new ModelLayerLocation(new ResourceLocation("deep_aether", type.getChestModelLocation()), "main") : new ModelLayerLocation(new ResourceLocation("deep_aether", type.getModelLocation()), "main");
        ModelPart modelPart = renderer.m_174023_(modelLayerLocation);
        return hasChest ? new BoatModel(modelPart, true) : new BoatModel(modelPart, false);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float f2;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.375, 0.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float f1 = entity.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entity.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.boatResources.get((Object)((DABoatEntity)((Object)entity)).getWoodType());
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel boatmodel = (ListModel)pair.getSecond();
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatmodel.m_6973_(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(boatmodel.m_103119_(resourcelocation));
        boatmodel.m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexconsumer1 = buffer.m_6299_(RenderType.m_110478_());
            if (boatmodel instanceof BoatModel) {
                ((BoatModel)boatmodel).m_102282_().m_104301_(matrixStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
            }
        }
        matrixStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(T boat) {
        return (ResourceLocation)this.boatResources.get((Object)((DABoatEntity)((Object)boat)).getWoodType()).getFirst();
    }
}

