/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import teamrazor.deepaether.block.Behaviors.GoldenVines;
import teamrazor.deepaether.datagen.tags.DATags;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.init.DAItems;

public class GoldenVinesBlock
extends GrowingPlantHeadBlock
implements BonemealableBlock,
GoldenVines {
    private final double growPerTickProbability = 0.02;

    public GoldenVinesBlock(BlockBehaviour.Properties p_152959_) {
        super(p_152959_, Direction.UP, SHAPE, false, 0.02);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53924_, (Comparable)Integer.valueOf(0))).m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected int m_213627_(RandomSource p_220928_) {
        return 1;
    }

    protected boolean m_5971_(BlockState p_152998_) {
        return p_152998_.m_60795_();
    }

    protected Block m_7777_() {
        return (Block)DABlocks.GOLDEN_VINES_PLANT.get();
    }

    protected BlockState m_142643_(BlockState p_152987_, BlockState p_152988_) {
        return (BlockState)p_152988_.m_61124_((Property)BERRIES, (Comparable)((Boolean)p_152987_.m_61143_((Property)BERRIES)));
    }

    protected BlockState m_214070_(BlockState p_220935_, RandomSource p_220936_) {
        return (BlockState)super.m_214070_(p_220935_, p_220936_).m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(p_220936_.m_188501_() < 0.5f));
    }

    public ItemStack m_7397_(BlockGetter p_152966_, BlockPos p_152967_, BlockState p_152968_) {
        return new ItemStack((ItemLike)DAItems.GOLDEN_BERRIES.get());
    }

    public InteractionResult m_6227_(BlockState p_152980_, Level p_152981_, BlockPos p_152982_, Player p_152983_, InteractionHand p_152984_, BlockHitResult p_152985_) {
        return GoldenVines.use((Entity)p_152983_, p_152980_, p_152981_, p_152982_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_152993_) {
        super.m_7926_(p_152993_);
        p_152993_.m_61104_(new Property[]{BERRIES});
    }

    public boolean isValidBonemealTarget(LevelReader p_256026_, BlockPos p_152971_, BlockState p_152972_, boolean p_152973_) {
        return (Boolean)p_152972_.m_61143_((Property)BERRIES) == false;
    }

    public boolean m_214167_(Level p_220930_, RandomSource p_220931_, BlockPos p_220932_, BlockState p_220933_) {
        return true;
    }

    public void m_214148_(ServerLevel p_220923_, RandomSource p_220924_, BlockPos p_220925_, BlockState p_220926_) {
        p_220923_.m_7731_(p_220925_, (BlockState)p_220926_.m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource p_221353_) {
        BlockPos blockpos;
        if ((Integer)state.m_61143_((Property)f_53924_) < 25 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_121945_(this.f_53859_), (BlockState)level.m_8055_(pos.m_121945_(this.f_53859_)), (p_221353_.m_188500_() < this.growPerTickProbability ? 1 : 0) != 0) && this.m_7898_(state, (LevelReader)level, pos.m_6630_(1)) && this.m_5971_(level.m_8055_(blockpos = pos.m_121945_(this.f_53859_)))) {
            level.m_46597_(blockpos, this.m_214070_(state, level.f_46441_));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)blockpos, (BlockState)level.m_8055_(blockpos));
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        boolean HasValidHightAndBlock = false;
        for (int i = 1; i < 5; ++i) {
            Block block = level.m_8055_(pos.m_6625_(i)).m_60734_();
            if (!block.m_49966_().m_204336_(DATags.Blocks.CAN_GOLDEN_VINES_SURVIVE_ON)) continue;
            HasValidHightAndBlock = true;
        }
        BlockPos blockpos = pos.m_121945_(this.f_53859_.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        if (!this.m_142209_(blockstate) || !HasValidHightAndBlock) {
            return false;
        }
        return blockstate.m_60713_((Block)this.m_7272_()) || blockstate.m_60713_(this.m_7777_()) || blockstate.m_60783_((BlockGetter)level, blockpos, this.f_53859_);
    }
}

