/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether;

import com.aetherteam.aether.entity.AetherEntityTypes;
import com.google.common.reflect.Reflection;
import com.mojang.bridge.game.GameVersion;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.Calendar;
import net.minecraft.SharedConstants;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;
import software.bernie.geckolib3.GeckoLib;
import teamrazor.aeroblender.aether.AetherRuleCategory;
import teamrazor.deepaether.DeepAetherConfig;
import teamrazor.deepaether.advancement.DAAdvancementTriggers;
import teamrazor.deepaether.block.Behaviors.DADispenseBehaviors;
import teamrazor.deepaether.block.Behaviors.DaCauldronInteraction;
import teamrazor.deepaether.datagen.loot.modifiers.DAGlobalLootModifiers;
import teamrazor.deepaether.event.DAGeneralEvents;
import teamrazor.deepaether.fluids.DAFluidTypes;
import teamrazor.deepaether.init.DABlockEntityTypes;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.init.DAEntities;
import teamrazor.deepaether.init.DAFluids;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.init.DAMobEffects;
import teamrazor.deepaether.init.DAParticles;
import teamrazor.deepaether.init.DASounds;
import teamrazor.deepaether.networking.DAPacketHandler;
import teamrazor.deepaether.recipe.DARecipe;
import teamrazor.deepaether.recipe.DARecipeSerializers;
import teamrazor.deepaether.world.biomes.DARegion;
import teamrazor.deepaether.world.biomes.DASurfaceData;
import teamrazor.deepaether.world.feature.DAFeatures;
import teamrazor.deepaether.world.feature.tree.decorators.DADecoratorType;
import teamrazor.deepaether.world.feature.tree.decorators.DARootPlacers;
import teamrazor.deepaether.world.feature.tree.foliage.DAFoliagePlacers;
import teamrazor.deepaether.world.feature.tree.trunk.DaTrunkPlacerTypes;
import teamrazor.deepaether.world.placementmodifier.DAPlacementModifiers;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="deep_aether")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DeepAetherMod {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "deep_aether";
    public static final String AETHER_REDUX = "aether_redux";
    private static final String PROTOCOL_VERSION = "1";
    static Calendar CALENDER = Calendar.getInstance();
    public static boolean IS_HALLOWEEN = CALENDER.get(2) == 9 && CALENDER.get(5) > 20 || CALENDER.get(2) == 10 && CALENDER.get(5) < 10;
    public static final Path DIRECTORY = FMLPaths.CONFIGDIR.get().resolve("deep_aether");
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("deep_aether", "deep_aether"), () -> "1", "1"::equals, "1"::equals);

    public static boolean IsHalloweenContentEnabled() {
        return IS_HALLOWEEN || (Boolean)DeepAetherConfig.COMMON.always_enable_halloween_content.get() != false;
    }

    public DeepAetherMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GeckoLib.initialize();
        DABlocks.BLOCKS.register(bus);
        DAItems.ITEMS.register(bus);
        DAParticles.PARTICLE_TYPES.register(bus);
        DAEntities.ENTITY_TYPES.register(bus);
        DASounds.SOUNDS.register(bus);
        DAFluids.FLUIDS.register(bus);
        DAFluidTypes.FLUID_TYPES.register(bus);
        DADecoratorType.REGISTRY.register(bus);
        DABlockEntityTypes.BLOCK_ENTITY_TYPES.register(bus);
        DABlocks.registerWoodTypes();
        DAFoliagePlacers.FOLIAGE_PLACERS.register(bus);
        DARootPlacers.ROOT_PLACERS.register(bus);
        DaTrunkPlacerTypes.TRUNK_PLACERS.register(bus);
        DAFeatures.FEATURES.register(bus);
        DAMobEffects.EFFECTS.register(bus);
        DAGlobalLootModifiers.LOOT_MODIFIERS.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DeepAetherConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DeepAetherConfig.CLIENT_SPEC);
        DARecipe.RECIPE_TYPES.register(bus);
        DARecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        DAPacketHandler.register();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        Reflection.initialize((Class[])new Class[]{DAPlacementModifiers.class});
        DAAdvancementTriggers.init();
        event.enqueueWork(() -> {
            DaCauldronInteraction.bootStrap();
            DABlocks.registerPots();
            DABlocks.registerFlammability();
            DAItems.setupBucketReplacements();
            this.registerDispenserBehaviors();
            this.registerCompostable();
            this.registerFlawlessBossDrops();
        });
        event.enqueueWork(() -> {
            Regions.register((Region)new DARegion(new ResourceLocation(MODID, MODID), (Integer)DeepAetherConfig.COMMON.deep_aether_biome_weight.get()));
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)AetherRuleCategory.THE_AETHER, (String)MODID, (SurfaceRules.RuleSource)DASurfaceData.makeRules());
        });
    }

    private void registerFlawlessBossDrops() {
        this.getFlawlessBossDrop((EntityType)AetherEntityTypes.SLIDER.get(), (String)DeepAetherConfig.COMMON.slider_flawless_boss_drop.get(), (Item)DAItems.SLIDER_EYE.get());
        this.getFlawlessBossDrop((EntityType)AetherEntityTypes.VALKYRIE_QUEEN.get(), (String)DeepAetherConfig.COMMON.valkyrie_queen_flawless_boss_drop.get(), (Item)DAItems.MEDAL_OF_HONOR.get());
        this.getFlawlessBossDrop((EntityType)AetherEntityTypes.SUN_SPIRIT.get(), (String)DeepAetherConfig.COMMON.sun_spirit_flawless_boss_drop.get(), (Item)DAItems.SUN_CORE.get());
    }

    private void getFlawlessBossDrop(EntityType type, String string, Item fallBack) {
        if (string.equals("null")) {
            DAGeneralEvents.FLAWLESS_BOSS_DROP.put(type, null);
        } else {
            String[] SliderItemId = string.split(":");
            if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(SliderItemId[0], SliderItemId[1]))) {
                DAGeneralEvents.FLAWLESS_BOSS_DROP.put(type, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(SliderItemId[0], SliderItemId[1])));
            } else {
                DAGeneralEvents.FLAWLESS_BOSS_DROP.put(type, fallBack);
                LOGGER.info("Config value " + string + " is referring to a missing item! Resolving to default value");
            }
        }
    }

    private void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)Items.f_42589_, (DispenseItemBehavior)DADispenseBehaviors.WATER_BOTTLE_TO_AETHER_MUD_DISPENSE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)DAItems.PLACEABLE_POISON_BUCKET.get()), (DispenseItemBehavior)DADispenseBehaviors.DEEP_AETHER_BUCKET_PICKUP_DISPENSE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)DAItems.VIRULENT_QUICKSAND_BUCKET.get()), (DispenseItemBehavior)DADispenseBehaviors.DEEP_AETHER_BUCKET_PICKUP_DISPENSE_BEHAVIOR);
    }

    public void registerCompostable() {
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.BLUE_ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.FLOWERING_ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.FLOWERING_BLUE_ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CRUDEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AETHER_MOSS_BLOCK.get()).m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AETHER_MOSS_CARPET.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ROSEROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CRUDEROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CONBERRY_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CONBERRY_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SUNROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SUNROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_ROOTS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_VINE.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SUNROOT_HANGER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AERGLOW_BLOSSOM_BLOCK.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.MINI_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SHORT_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.MEDIUM_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.RADIANT_ORCHID.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AERLAVENDER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_AERLAVENDER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AETHER_CATTAILS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_AETHER_CATTAILS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.GOLDEN_FLOWER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SKY_TULIPS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.IASPOVE.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ENCHANTED_BLOSSOM.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ECHAISY.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.LIGHTCAP_MUSHROOMS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.GOLDEN_ASPESS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.FEATHER_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_FEATHER_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.AERGLOW_BLOSSOM.get()), 0.1f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.GOLDEN_BERRIES.get()), 0.2f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.GOLDEN_GRASS_SEEDS.get()), 0.1f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.SQUASH_SEEDS.get()), 0.1f);
    }

    @SubscribeEvent
    public static void addAetherAdditionalResourcesPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/overrides/deep_aether_additional_assets"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237113_((String)"Deep Aether Additional Assets"), PackType.CLIENT_RESOURCES.m_143756_((GameVersion)SharedConstants.m_183709_()));
            event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/deep_aether_additional_assets", (Component)Component.m_237113_((String)"Deep Aether Additional Assets"), false, () -> pack, metadata, Pack.Position.TOP, PackSource.f_10528_, false)));
            if (ModList.get().isLoaded("aether_genesis") || ModList.get().isLoaded(AETHER_REDUX)) {
                Path resourcePath1 = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/golden_swet_ball/DAGoldenSwetBallFixClient"});
                PathPackResources pack1 = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath1, resourcePath1);
                PackMetadataSection metadata1 = new PackMetadataSection((Component)Component.m_237113_((String)"Deep Aether Golden Swet Ball Texture Fix"), PackType.CLIENT_RESOURCES.m_143756_((GameVersion)SharedConstants.m_183709_()));
                event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/DAGoldenSwetBallFixClient", (Component)Component.m_237113_((String)"Deep Aether Golden Swet Ball Texture Fix"), false, () -> pack1, metadata1, Pack.Position.TOP, PackSource.f_10527_, true)));
            }
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            PackMetadataSection metadata;
            PathPackResources pack;
            Path resourcePath;
            if (ModList.get().isLoaded("aether_genesis")) {
                resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/golden_swet_ball/DAGoldenSwetBallAetherGenesisFixData"});
                pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, resourcePath);
                metadata = new PackMetadataSection((Component)Component.m_237113_((String)"Deep Aether Golden Swet Ball Aether Genesis Fix"), PackType.SERVER_DATA.m_143756_((GameVersion)SharedConstants.m_183709_()));
                event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/DAGoldenSwetBallAetherGenesisFix", (Component)Component.m_237113_((String)"Deep Aether Golden Swet Ball Aether Genesis Fix"), false, () -> pack, metadata, Pack.Position.TOP, PackSource.f_10530_, true)));
            } else if (ModList.get().isLoaded(AETHER_REDUX)) {
                resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/golden_swet_ball/DAGoldenSwetBallAetherReduxFixData"});
                pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, resourcePath);
                metadata = new PackMetadataSection((Component)Component.m_237113_((String)"Deep Aether Golden Swet Ball Aether Redux Fix"), PackType.SERVER_DATA.m_143756_((GameVersion)SharedConstants.m_183709_()));
                event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/DAGoldenSwetBallAetherReduxFix", (Component)Component.m_237113_((String)"Deep Aether Golden Swet Ball Aether Redux Fix"), false, () -> pack, metadata, Pack.Position.TOP, PackSource.f_10530_, true)));
            }
            if (ModList.get().isLoaded(AETHER_REDUX)) {
                resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/compat_recipes/aether_redux_compat"});
                pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, resourcePath);
                metadata = new PackMetadataSection((Component)Component.m_237113_((String)"Aether Redux Compat"), PackType.SERVER_DATA.m_143756_((GameVersion)SharedConstants.m_183709_()));
                event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/aether_redux_compat", (Component)Component.m_237113_((String)"Aether Redux Compat"), true, () -> pack, metadata, Pack.Position.TOP, PackSource.f_10530_, true)));
            }
        }
    }
}

