/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.item.custom;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.RandomUtils;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.VecUtils;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.particle.ClientParticleBuilder;
import com.cerbon.bosses_of_mass_destruction.util.BMDColors;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import com.cerbon.bosses_of_mass_destruction.util.Vec3Receiver;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;

public class BrimstoneNectarItemEffects
implements Vec3Receiver {
    private final ClientParticleBuilder horizontalRodParticle = new ClientParticleBuilder((ParticleOptions)BMDParticles.GROUND_ROD.get()).color(f -> MathUtils.lerpVec(f.floatValue(), BMDColors.GOLD, BMDColors.RUNIC_BROWN)).colorVariation(0.25).brightness(0xF000F0).age(10, 15);
    private final ClientParticleBuilder particleBuilder2 = new ClientParticleBuilder((ParticleOptions)BMDParticles.EARTHDIVE_INDICATOR.get()).color(f -> MathUtils.lerpVec(f.floatValue(), BMDColors.RED, BMDColors.DARK_RED)).colorVariation(0.25).brightness(0xF000F0).age(30, 45);
    private final ClientParticleBuilder particleBuilder3 = new ClientParticleBuilder((ParticleOptions)BMDParticles.EARTHDIVE_INDICATOR.get()).color(f -> MathUtils.lerpVec(f.floatValue(), BMDColors.WHITE, BMDColors.GREY)).colorVariation(0.25).brightness(0xF000F0).age(40, 50);

    @Override
    public void clientHandler(ClientLevel level, Vec3 vec3) {
        BMDUtils.RotatingParticles particleParams;
        Vec3 pos;
        int i;
        for (i = 1; i <= 3; ++i) {
            this.spawnHorizontalRods(i, VecUtils.yOffset(vec3, 0.1));
        }
        for (i = 0; i <= 30; ++i) {
            pos = VecUtils.yOffset(vec3, RandomUtils.range(0.0, 1.5));
            particleParams = new BMDUtils.RotatingParticles(pos, this.particleBuilder2, 1.5, 2.5, 0.0, 2.0);
            BMDUtils.spawnRotatingParticles(particleParams);
        }
        for (i = 0; i <= 30; ++i) {
            pos = VecUtils.yOffset(vec3, RandomUtils.range(0.0, 1.5));
            particleParams = new BMDUtils.RotatingParticles(pos, this.particleBuilder3, 2.0, 3.0, -1.0, 0.0);
            BMDUtils.spawnRotatingParticles(particleParams);
        }
    }

    private void spawnHorizontalRods(double radius, Vec3 pos) {
        double numPoints = radius * 6.0;
        MathUtils.circleCallback(radius, (int)numPoints, VecUtils.yAxis, vec3 -> {
            Vec3 offset = vec3.m_82549_(new Vec3(RandomUtils.range(-0.5, 0.5), 0.0, RandomUtils.range(-0.5, 0.5)));
            this.horizontalRodParticle.rotation(Float.valueOf((float)(-MathUtils.directionToYaw(offset)) + 90.0f)).build(pos.m_82549_(offset), Vec3.f_82478_);
        });
    }
}

