/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script.scriptrun;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IMutableScriptRunInfo;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptFile;
import com.blamejared.crafttweaker.impl.script.scriptrun.MutableRunInfo;
import com.blamejared.crafttweaker.impl.script.scriptrun.PreprocessedSourceFile;
import com.blamejared.crafttweaker.impl.script.scriptrun.RunInfo;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import org.openzen.zencode.shared.SourceFile;

final class ScriptFile
implements IScriptFile {
    private final String fileName;
    private final Map<IPreprocessor, List<IPreprocessor.Match>> matches;
    private final RunInfo info;
    private final List<String> fileContents;
    private final Supplier<PreprocessedData> preprocessedFile;

    private ScriptFile(String fileName, Map<IPreprocessor, List<IPreprocessor.Match>> matches, List<String> contents, RunInfo info) {
        this.fileName = fileName;
        this.matches = new HashMap<IPreprocessor, List<IPreprocessor.Match>>(matches);
        this.fileContents = ImmutableList.copyOf(contents);
        this.info = info;
        this.preprocessedFile = Suppliers.memoize(this::preprocess);
    }

    static ScriptFile of(String name, Stream<String> lines, RunInfo info, Collection<IPreprocessor> preprocessors) {
        Map<String, IPreprocessor> fastPreprocessorLookupMap = ScriptFile.buildFastLookupMap(preprocessors);
        Pair<List<String>, Map<IPreprocessor, List<IPreprocessor.Match>>> data = ScriptFile.read(lines, fastPreprocessorLookupMap);
        preprocessors.forEach(pp -> ((Map)data.getSecond()).computeIfAbsent(pp, it -> pp.defaultValue() != null ? List.of(new IPreprocessor.Match((IPreprocessor)pp, -1, pp.defaultValue())) : null));
        return new ScriptFile(name, (Map)data.getSecond(), (List)data.getFirst(), info);
    }

    static ScriptFile of(Path baseDirectory, Path file, RunInfo info, Collection<IPreprocessor> preprocessors) {
        if (!ScriptFile.verifyChild(baseDirectory, file)) {
            throw new IllegalArgumentException("File " + file + " is not contained within " + baseDirectory);
        }
        String name = baseDirectory.toAbsolutePath().relativize(file.toAbsolutePath()).toString();
        try (Stream<String> lines = ScriptFile.lines(file);){
            ScriptFile scriptFile = ScriptFile.of(name, lines, info, preprocessors);
            return scriptFile;
        }
    }

    private static boolean verifyChild(Path parent, Path file) {
        for (Path current = file; current != null; current = current.getParent()) {
            if (!current.equals(parent)) continue;
            return true;
        }
        return false;
    }

    private static Stream<String> lines(Path file) {
        try {
            return Files.lines(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            CraftTweakerAPI.LOGGER.error("Could not load file {}", (Object)file, (Object)e);
            return Stream.of(new String[0]);
        }
    }

    private static Map<String, IPreprocessor> buildFastLookupMap(Collection<IPreprocessor> preprocessors) {
        return preprocessors.stream().collect(Collectors.toMap(IPreprocessor::name, Function.identity()));
    }

    private static Pair<List<String>, Map<IPreprocessor, List<IPreprocessor.Match>>> read(Stream<String> lines, Map<String, IPreprocessor> preprocessors) {
        ArrayList contents = new ArrayList();
        HashMap matches = new HashMap();
        AtomicInteger lineCounter = new AtomicInteger();
        lines.forEachOrdered(it -> {
            contents.add(it);
            ScriptFile.tryReadingPreprocessors(it, lineCounter.incrementAndGet(), matches, preprocessors);
        });
        return Pair.of(contents, matches);
    }

    private static void tryReadingPreprocessors(String line, int lineNumber, Map<IPreprocessor, List<IPreprocessor.Match>> matches, Map<String, IPreprocessor> preprocessors) {
        Matcher matcher = IPreprocessor.PREPROCESSOR_PATTERN.matcher(line);
        if (!matcher.find()) {
            return;
        }
        String name = matcher.group().substring(1).trim().toLowerCase(Locale.ENGLISH);
        IPreprocessor preprocessor = preprocessors.get(name);
        if (preprocessor == null) {
            return;
        }
        IPreprocessor.Match match = new IPreprocessor.Match(preprocessor, lineNumber, line.substring(matcher.end()));
        matches.computeIfAbsent(preprocessor, it -> new ArrayList(1)).add(match);
    }

    @Override
    public String name() {
        return this.fileName;
    }

    @Override
    public List<String> fileContents() {
        return this.fileContents;
    }

    @Override
    public List<String> preprocessedContents() {
        return this.preprocessedFile.get().contents();
    }

    @Override
    public Optional<SourceFile> toSourceFile() {
        return this.preprocessedFile.get().allowLoading() ? Optional.of(this.toFile()) : Optional.empty();
    }

    @Override
    public List<IPreprocessor.Match> matchesFor(IPreprocessor preprocessor) {
        return Optional.ofNullable(this.matches.get(preprocessor)).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
    }

    private PreprocessedData preprocess() {
        ToIntFunction<Map.Entry> intExtractor = it -> ((IPreprocessor)it.getKey()).priority();
        MutableRunInfo mutableInfo = new MutableRunInfo(this.info);
        return this.matches.entrySet().stream().sorted(Comparator.comparingInt(intExtractor).reversed()).reduce(new PreprocessedData(new ArrayList<String>(this.fileContents), true), (data, entry) -> this.preprocess((PreprocessedData)data, (Map.Entry<IPreprocessor, List<IPreprocessor.Match>>)entry, mutableInfo), this::combine);
    }

    private PreprocessedData preprocess(PreprocessedData data, Map.Entry<IPreprocessor, List<IPreprocessor.Match>> entry, IMutableScriptRunInfo info) {
        if (!data.allowLoading()) {
            return data;
        }
        ArrayList<String> newContents = new ArrayList<String>(data.contents());
        boolean load = entry.getKey().apply(this, newContents, info, entry.getValue());
        return new PreprocessedData(newContents, load);
    }

    private PreprocessedData combine(PreprocessedData a, PreprocessedData b) {
        return new PreprocessedData(this.intersect(a.contents(), b.contents()), a.allowLoading() && b.allowLoading());
    }

    private List<String> intersect(List<String> a, List<String> b) {
        return (List)Util.m_137469_(new ArrayList<String>(a), it -> it.retainAll(b));
    }

    private SourceFile toFile() {
        return new PreprocessedSourceFile(this.fileName, this.preprocessedContents(), this.matches);
    }

    private record PreprocessedData(List<String> contents, boolean allowLoading) {
    }
}

