/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStack
implements IFluidStack {
    public static Supplier<MCFluidStack> EMPTY = () -> new MCFluidStack(FluidStack.EMPTY);
    private final FluidStack stack;

    public MCFluidStack(FluidStack fluidStack) {
        this.stack = fluidStack;
    }

    @Override
    public String getCommandString() {
        IData data;
        Fluid fluid = this.getInternal().getFluid();
        StringBuilder builder = new StringBuilder().append("<fluid:").append(Registry.f_122822_.m_7981_((Object)fluid)).append(">");
        if (this.getInternal().hasTag() && !(data = TagToDataConverter.convert((Tag)this.getInternal().getTag()).copyInternal()).isEmpty()) {
            builder.append(".withTag(");
            builder.append(data.asString());
            builder.append(")");
        }
        if (!this.isEmpty() && this.getInternal().getAmount() != 1) {
            builder.append(" * ").append(this.getInternal().getAmount());
        }
        return builder.toString();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        FluidStack copy = this.getInternal().copy();
        copy.setAmount(amount);
        return IFluidStack.of(copy);
    }

    @Override
    public IFluidStack multiply(int amount) {
        return this.setAmount(amount);
    }

    @Override
    public IFluidStack mutable() {
        return IFluidStack.ofMutable(this.getInternal());
    }

    @Override
    public IFluidStack asImmutable() {
        return this;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public IFluidStack copy() {
        return IFluidStack.of(this.getInternal().copy());
    }

    @Override
    public Fluid getFluid() {
        return this.getInternal().getFluid();
    }

    @Override
    public IFluidStack withTag(@ZenCodeType.Nullable IData tag) {
        FluidStack copy = this.getInternal().copy();
        if (tag != null) {
            MapData map = new MapData(tag.asMap());
            copy.setTag(map.getInternal());
        } else {
            copy.setTag(null);
        }
        return IFluidStack.of(copy);
    }

    @Override
    public IData getTag() {
        return TagToDataConverter.convert((Tag)this.getInternal().getTag());
    }

    @Override
    public FluidStack getInternal() {
        return this.stack;
    }

    @Override
    public FluidStack getImmutableInternal() {
        return this.stack;
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStack thatStack = ((MCFluidStack)o).getInternal();
        FluidStack thisStack = this.getInternal();
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.getAmount() != thatStack.getAmount()) {
            return false;
        }
        if (!Objects.equals(thisStack.getFluid(), thatStack.getFluid())) {
            return false;
        }
        return Objects.equals(thisStack.getTag(), thatStack.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().getAmount(), this.getInternal().getFluid(), this.getInternal().getTag());
    }
}

