/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.ItemCollectionRegistry;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.mojang.authlib.GameProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityController
extends BaseBlockEntity
implements IDrawerGroup {
    public static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerAttributes>(){});
    private static final int PRI_LOCKED = 0;
    private static final int PRI_NORMAL = 1;
    private static final int PRI_LOCKED_VOID = 2;
    private static final int PRI_VOID = 3;
    private static final int PRI_EMPTY = 4;
    private static final int PRI_LOCKED_EMPTY = 5;
    private static final int PRI_DISABLED = 6;
    private final Queue<BlockPos> searchQueue = new LinkedList<BlockPos>();
    private final Set<BlockPos> searchDiscovered = new HashSet<BlockPos>();
    private final Comparator<SlotRecord> slotRecordComparator = Comparator.comparingInt(o -> o.priority);
    private final Map<BlockPos, StorageRecord> storage = new HashMap<BlockPos, StorageRecord>();
    protected List<SlotRecord> drawerSlotList = new ArrayList<SlotRecord>();
    private final ItemCollectionRegistry<SlotRecord> drawerPrimaryLookup = new ItemCollectionRegistry();
    protected int[] drawerSlots = new int[0];
    private final int range;
    private long lastUpdateTime;
    private long lastClickTime;
    private UUID lastClickUUID;
    static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemRepository>(){});
    static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerGroup>(){});
    private final DrawerItemHandler itemHandler = new DrawerItemHandler(this);
    private final ItemRepository itemRepository = new ItemRepository(this);
    private final LazyOptional<IItemHandler> capabilityItemHandler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemRepository> capabilityItemRepository = LazyOptional.of(() -> this.itemRepository);
    private final LazyOptional<IDrawerGroup> capabilityGroup = LazyOptional.of(() -> this);

    private IDrawerAttributes getAttributes(Object obj) {
        IDrawerAttributes attrs = EmptyDrawerAttributes.EMPTY;
        if (obj instanceof ICapabilityProvider) {
            attrs = (IDrawerAttributes)((ICapabilityProvider)obj).getCapability(DRAWER_ATTRIBUTES_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
        }
        return attrs;
    }

    private int getSlotPriority(SlotRecord record) {
        IDrawerGroup group = this.getGroupForSlotRecord(record);
        if (group == null) {
            return 6;
        }
        int drawerSlot = record.slot;
        IDrawer drawer = group.getDrawer(drawerSlot);
        if (!drawer.isEnabled()) {
            return 6;
        }
        IDrawerAttributes attrs = this.getAttributes(group);
        if (drawer.isEmpty()) {
            if (attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return 5;
            }
            return 4;
        }
        if (attrs.isVoid()) {
            if (attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                return 2;
            }
            return 3;
        }
        if (attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            return 0;
        }
        return 1;
    }

    protected BlockEntityController(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.range = (Integer)CommonConfig.GENERAL.controllerRange.get();
    }

    public BlockEntityController(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CONTROLLER.get(), pos, state);
    }

    public void printDebugInfo() {
        StorageDrawers.log.info("Controller at " + this.f_58858_);
        StorageDrawers.log.info("  Range: " + this.range + " blocks");
        StorageDrawers.log.info("  Stored records: " + this.storage.size() + ", slot list: " + this.drawerSlots.length);
        StorageDrawers.log.info("  Ticks since last update: " + (Serializable)(this.m_58904_() == null ? "null" : Long.valueOf(this.m_58904_().m_46467_() - this.lastUpdateTime)));
    }

    public void m_6339_() {
        super.m_6339_();
        if (this.m_58904_() == null) {
            return;
        }
        if (!this.m_58904_().m_183326_().m_183582_(this.m_58899_(), (Object)((Block)ModBlocks.CONTROLLER.get()))) {
            this.m_58904_().m_186460_(this.m_58899_(), (Block)ModBlocks.CONTROLLER.get(), 1);
        }
    }

    @Override
    public boolean isGroupValid() {
        return !this.m_58901_();
    }

    public int interactPutItemsIntoInventory(Player player) {
        int count;
        block3: {
            block2: {
                if (this.m_58904_() == null) {
                    return 0;
                }
                boolean dumpInventory = this.m_58904_().m_46467_() - this.lastClickTime < 10L && player.m_20148_().equals(this.lastClickUUID);
                count = 0;
                if (dumpInventory) break block2;
                ItemStack currentStack = player.m_150109_().m_36056_();
                if (currentStack.m_41619_()) break block3;
                count = this.insertItems(currentStack, player.m_36316_());
                if (currentStack.m_41613_() != 0) break block3;
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
                break block3;
            }
            int n = player.m_150109_().m_6643_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.m_150109_().m_8020_(i);
                if (subStack.m_41619_()) continue;
                count += this.insertItems(subStack, player.m_36316_());
                if (subStack.m_41613_() != 0) continue;
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
        }
        this.lastClickTime = this.m_58904_().m_46467_();
        this.lastClickUUID = player.m_20148_();
        return count;
    }

    protected int insertItems(@NotNull ItemStack stack, GameProfile profile) {
        int remainder = new ProtectedItemRepository(this, profile).insertItem(stack, false).m_41613_();
        int added = stack.m_41613_() - remainder;
        stack.m_41764_(remainder);
        return added;
    }

    public void toggleProtection(GameProfile profile, ISecurityProvider provider) {
        IProtectable template = null;
        UUID state = null;
        for (StorageRecord record : this.storage.values()) {
            IProtectable protectable;
            IDrawerGroup iDrawerGroup;
            if (record.storage == null || !((iDrawerGroup = record.storage) instanceof IProtectable) || !SecurityManager.hasOwnership(profile, protectable = (IProtectable)((Object)iDrawerGroup))) continue;
            if (template == null) {
                template = protectable;
                if (template.getOwner() == null) {
                    state = profile.getId();
                } else {
                    provider = null;
                }
            }
            protectable.setOwner(state);
            protectable.setSecurityProvider(provider);
        }
    }

    public void toggleShroud(GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerAttributes attrs;
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage)) || !((attrs = this.getAttributes(record.storage)) instanceof IDrawerAttributesModifiable)) continue;
            IDrawerAttributesModifiable mattrs = (IDrawerAttributesModifiable)attrs;
            if (template == null) {
                template = mattrs.isConcealed();
                state = template == false;
            }
            mattrs.setIsConcealed(state);
        }
    }

    public void toggleQuantified(GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerAttributes attrs;
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage)) || !((attrs = this.getAttributes(record.storage)) instanceof IDrawerAttributesModifiable)) continue;
            IDrawerAttributesModifiable mattrs = (IDrawerAttributesModifiable)attrs;
            if (template == null) {
                template = mattrs.isShowingQuantity();
                state = template == false;
            }
            mattrs.setIsShowingQuantity(state);
        }
    }

    public void toggleLock(EnumSet<LockAttribute> attributes, LockAttribute key, GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerAttributes attrs;
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage)) || !((attrs = this.getAttributes(record.storage)) instanceof IDrawerAttributesModifiable)) continue;
            IDrawerAttributesModifiable mattrs = (IDrawerAttributesModifiable)attrs;
            if (template == null) {
                template = mattrs.isItemLocked(key);
                state = template == false;
            }
            for (LockAttribute attr : attributes) {
                mattrs.setItemLocked(attr, state);
            }
        }
    }

    protected void resetCache() {
        this.storage.clear();
        this.drawerSlotList.clear();
    }

    public boolean isValidSlave(BlockPos coord) {
        StorageRecord record = this.storage.get(coord);
        if (record == null || !record.mark) {
            return false;
        }
        return record.storage == null;
    }

    public void updateCache() {
        if (this.m_58904_() == null) {
            return;
        }
        this.lastUpdateTime = this.m_58904_().m_46467_();
        int preCount = this.drawerSlots.length;
        this.resetCache();
        this.populateNodes(this.m_58899_());
        this.flattenLists();
        this.drawerSlots = this.sortSlotRecords(this.drawerSlotList);
        this.rebuildPrimaryLookup(this.drawerPrimaryLookup, this.drawerSlotList);
        if (!(preCount == this.drawerSlots.length || preCount != 0 && this.drawerSlots.length != 0 || this.m_58904_().f_46443_)) {
            this.m_6596_();
        }
    }

    private void indexSlotRecords(List<SlotRecord> records) {
        int n = records.size();
        for (int i = 0; i < n; ++i) {
            SlotRecord record = records.get(i);
            if (record == null) continue;
            record.index = i;
            record.priority = this.getSlotPriority(record);
        }
    }

    private int[] sortSlotRecords(List<SlotRecord> records) {
        this.indexSlotRecords(records);
        ArrayList<SlotRecord> copied = new ArrayList<SlotRecord>(records);
        copied.sort(this.slotRecordComparator);
        int[] slotMap = new int[copied.size()];
        for (int i = 0; i < slotMap.length; ++i) {
            slotMap[i] = ((SlotRecord)copied.get((int)i)).index;
        }
        return slotMap;
    }

    private void rebuildPrimaryLookup(ItemCollectionRegistry<SlotRecord> lookup, List<SlotRecord> records) {
        lookup.clear();
        for (SlotRecord record : records) {
            int drawerSlot;
            IDrawer drawer;
            IDrawerGroup group = this.getGroupForSlotRecord(record);
            if (group == null || !(drawer = group.getDrawer(drawerSlot = record.slot)).isEnabled() || drawer.isEmpty()) continue;
            ItemStack item = drawer.getStoredItemPrototype();
            lookup.register(item.m_41720_(), record);
        }
    }

    private boolean containsNullEntries(List<SlotRecord> list) {
        int nullCount = 0;
        for (SlotRecord aList : list) {
            if (aList != null) continue;
            ++nullCount;
        }
        return nullCount > 0;
    }

    private void flattenLists() {
        if (this.containsNullEntries(this.drawerSlotList)) {
            ArrayList<SlotRecord> newDrawerSlotList = new ArrayList<SlotRecord>();
            for (SlotRecord record : this.drawerSlotList) {
                if (record == null) continue;
                newDrawerSlotList.add(record);
            }
            this.drawerSlotList = newDrawerSlotList;
        }
    }

    private void clearRecordInfo(BlockPos coord, StorageRecord record) {
        record.clear();
        for (int i = 0; i < this.drawerSlotList.size(); ++i) {
            SlotRecord slotRecord = this.drawerSlotList.get(i);
            if (slotRecord == null || !coord.equals((Object)slotRecord.coord)) continue;
            this.drawerSlotList.set(i, null);
        }
    }

    private void updateRecordInfo(BlockPos coord, StorageRecord record, BlockEntity blockEntity) {
        if (blockEntity == null) {
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            return;
        }
        if (blockEntity instanceof BlockEntityController) {
            if (record.storage == null && record.invStorageSize > 0) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
        } else if (blockEntity instanceof BlockEntitySlave) {
            if (record.storage == null && record.invStorageSize == 0 && ((BlockEntitySlave)blockEntity).getController() == this) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            ((BlockEntitySlave)blockEntity).bindController(this.m_58899_());
        } else if (blockEntity instanceof BlockEntityDrawers) {
            IDrawerGroup group = ((BlockEntityDrawers)blockEntity).getGroup();
            if (record.storage == group) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = group;
            record.drawerStorageSize = group.getDrawerCount();
            int n = record.drawerStorageSize;
            for (int i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(group, coord, i));
            }
        } else {
            IDrawerGroup group = (IDrawerGroup)blockEntity.getCapability(DRAWER_GROUP_CAPABILITY, null).orElse(null);
            if (record.storage == group) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            if (group == null) {
                return;
            }
            record.storage = group;
            record.drawerStorageSize = group.getDrawerCount();
            int n = record.drawerStorageSize;
            for (int i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(group, coord, i));
            }
        }
    }

    private void populateNodes(BlockPos root) {
        if (this.m_58904_() == null) {
            return;
        }
        this.searchQueue.clear();
        this.searchQueue.add(root);
        this.searchDiscovered.clear();
        this.searchDiscovered.add(root);
        while (!this.searchQueue.isEmpty()) {
            BlockPos[] neighbors;
            Block block;
            BlockPos coord = this.searchQueue.remove();
            int depth = Math.max(Math.max(Math.abs(coord.m_123341_() - root.m_123341_()), Math.abs(coord.m_123342_() - root.m_123342_())), Math.abs(coord.m_123343_() - root.m_123343_()));
            if (depth > this.range || !this.m_58904_().m_46749_(coord) || !((block = this.m_58904_().m_8055_(coord).m_60734_()) instanceof INetworked)) continue;
            StorageRecord record = this.storage.get(coord);
            if (record == null) {
                record = new StorageRecord();
                this.storage.put(coord, record);
            }
            if (block instanceof BlockSlave) {
                WorldUtils.getBlockEntity((BlockGetter)this.m_58904_(), coord, BlockEntitySlave.class);
            }
            this.updateRecordInfo(coord, record, this.m_58904_().m_7702_(coord));
            record.mark = true;
            record.distance = depth;
            for (BlockPos n : neighbors = new BlockPos[]{coord.m_122024_(), coord.m_122029_(), coord.m_122019_(), coord.m_122012_(), coord.m_7494_(), coord.m_7495_()}) {
                if (this.searchDiscovered.contains(n)) continue;
                this.searchQueue.add(n);
                this.searchDiscovered.add(n);
            }
        }
    }

    protected IDrawerGroup getGroupForDrawerSlot(int drawerSlot) {
        if (drawerSlot < 0 || drawerSlot >= this.drawerSlotList.size()) {
            return null;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForSlotRecord(record);
    }

    protected IDrawerGroup getGroupForSlotRecord(SlotRecord record) {
        BlockEntity tile;
        IDrawerGroup group = record.group;
        if (group == null || !group.isGroupValid()) {
            return null;
        }
        if (group instanceof BlockEntity && ((tile = (BlockEntity)group).m_58901_() || !tile.m_58899_().equals((Object)record.coord))) {
            record.group = null;
            return null;
        }
        return group;
    }

    private int getLocalDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    @Override
    public void readFixed(CompoundTag tag) {
        super.readFixed(tag);
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            this.updateCache();
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    public int getDrawerCount() {
        return this.drawerSlotList.size();
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return Drawers.DISABLED;
        }
        return group.getDrawer(this.getLocalDrawerSlot(slot));
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.drawerSlots;
    }

    public IItemRepository getItemRepository() {
        return this.itemRepository;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return this.capabilityItemHandler.cast();
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return this.capabilityItemRepository.cast();
        }
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return this.capabilityGroup.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.capabilityItemHandler.invalidate();
        this.capabilityItemRepository.invalidate();
        this.capabilityGroup.invalidate();
    }

    protected static class SlotRecord
    implements Comparable<SlotRecord> {
        public BlockPos coord;
        public IDrawerGroup group;
        public int slot;
        public int index;
        public int priority;

        public SlotRecord(IDrawerGroup group, BlockPos coord, int slot) {
            this.group = group;
            this.coord = coord;
            this.slot = slot;
        }

        @Override
        public int compareTo(SlotRecord other) {
            int diff = this.priority - other.priority;
            if (diff == 0) {
                diff = this.coord.compareTo((Vec3i)other.coord);
                if (diff == 0) {
                    return this.index - other.index;
                }
                return diff;
            }
            return diff;
        }
    }

    private class ItemRepository
    extends DrawerItemRepository {
        public ItemRepository(IDrawerGroup group) {
            super(group);
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            Collection<SlotRecord> primaryRecords = BlockEntityController.this.drawerPrimaryLookup.getEntries(stack.m_41720_());
            HashSet<Integer> checkedSlots = simulate ? new HashSet<Integer>() : null;
            int amount = stack.m_41613_();
            if (primaryRecords != null) {
                IDrawer drawer;
                IDrawerGroup candidateGroup;
                for (SlotRecord record : primaryRecords) {
                    candidateGroup = BlockEntityController.this.getGroupForSlotRecord(record);
                    if (candidateGroup == null || (drawer = candidateGroup.getDrawer(record.slot)).isEmpty() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer)) continue;
                    int adjusted = Math.min(amount, drawer.getRemainingCapacity());
                    int n = amount = simulate ? Math.max(amount - drawer.getRemainingCapacity(), 0) : amount - adjusted + drawer.adjustStoredItemCount(adjusted);
                    if (amount == 0) {
                        return ItemStack.f_41583_;
                    }
                    if (!simulate) continue;
                    checkedSlots.add(record.index);
                }
                for (SlotRecord record : primaryRecords) {
                    candidateGroup = BlockEntityController.this.getGroupForSlotRecord(record);
                    if (candidateGroup == null || (drawer = candidateGroup.getDrawer(record.slot)).isEmpty() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer)) continue;
                    int n = amount = simulate ? Math.max(amount - drawer.getAcceptingRemainingCapacity(), 0) : drawer.adjustStoredItemCount(amount);
                    if (amount == 0) {
                        return ItemStack.f_41583_;
                    }
                    if (!simulate) continue;
                    checkedSlots.add(record.index);
                }
            }
            for (Iterator<SlotRecord> slot : (Iterator<SlotRecord>)BlockEntityController.this.drawerSlots) {
                IDrawer drawer = BlockEntityController.this.getDrawer((int)slot);
                if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(BlockEntityController.this.getGroupForDrawerSlot((int)slot), drawer) || simulate && checkedSlots.contains(Integer.valueOf(slot))) continue;
                boolean empty = drawer.isEmpty();
                if (empty && !simulate) {
                    drawer = drawer.setStoredItem(stack);
                }
                int n = simulate ? Math.max(amount - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (amount = drawer.adjustStoredItemCount(amount));
                if (amount != 0) continue;
                return ItemStack.f_41583_;
            }
            return this.stackResult(stack, amount);
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            Collection<SlotRecord> primaryRecords = BlockEntityController.this.drawerPrimaryLookup.getEntries(stack.m_41720_());
            HashSet<Integer> checkedSlots = simulate ? new HashSet<Integer>() : null;
            int remaining = amount;
            if (primaryRecords != null) {
                for (SlotRecord record : primaryRecords) {
                    IDrawer drawer;
                    IDrawerGroup candidateGroup = BlockEntityController.this.getGroupForSlotRecord(record);
                    if (candidateGroup == null || !(drawer = candidateGroup.getDrawer(record.slot)).isEnabled() || !this.testPredicateExtract(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer)) continue;
                    int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
                    if (remaining == 0) {
                        return this.stackResult(stack, amount);
                    }
                    if (!simulate) continue;
                    checkedSlots.add(record.index);
                }
            }
            for (Object slot : (Object)BlockEntityController.this.drawerSlots) {
                IDrawer drawer = BlockEntityController.this.getDrawer((int)slot);
                if (!drawer.isEnabled() || !this.testPredicateExtract(drawer, stack, predicate) || simulate && checkedSlots.contains((int)slot)) continue;
                int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
                if (remaining != 0) continue;
                return this.stackResult(stack, amount);
            }
            return amount == remaining ? ItemStack.f_41583_ : this.stackResult(stack, amount - remaining);
        }

        protected boolean hasAccess(IDrawerGroup group, IDrawer drawer) {
            return true;
        }
    }

    private class ProtectedItemRepository
    extends ItemRepository {
        private final GameProfile profile;

        public ProtectedItemRepository(IDrawerGroup group, GameProfile profile) {
            super(group);
            this.profile = profile;
        }

        @Override
        protected boolean hasAccess(IDrawerGroup group, IDrawer drawer) {
            if (drawer.isEmpty()) {
                return false;
            }
            if (group instanceof IProtectable) {
                return SecurityManager.hasAccess(this.profile, (IProtectable)((Object)group));
            }
            return true;
        }
    }

    private static class StorageRecord {
        public IDrawerGroup storage;
        public boolean mark;
        public int invStorageSize;
        public int drawerStorageSize;
        public int distance = Integer.MAX_VALUE;

        private StorageRecord() {
        }

        public void clear() {
            this.storage = null;
            this.mark = false;
            this.invStorageSize = 0;
            this.drawerStorageSize = 0;
            this.distance = Integer.MAX_VALUE;
        }
    }
}

