/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockKeyButton
extends FaceAttachedHorizontalDirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape CEILING_AABB_X = Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape CEILING_AABB_Z = Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape FLOOR_AABB_X = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    protected static final VoxelShape FLOOR_AABB_Z = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0);
    protected static final VoxelShape PRESSED_CEILING_AABB_X = Block.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape PRESSED_CEILING_AABB_Z = Block.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape PRESSED_FLOOR_AABB_X = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape PRESSED_FLOOR_AABB_Z = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape PRESSED_NORTH_AABB = Block.m_49796_((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape PRESSED_SOUTH_AABB = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0);
    protected static final VoxelShape PRESSED_WEST_AABB = Block.m_49796_((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape PRESSED_EAST_AABB = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0);
    private final EnumKeyType keyType;

    public BlockKeyButton(BlockBehaviour.Properties properties, EnumKeyType keyType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL));
        this.keyType = keyType;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                if (dir.m_122434_() == Direction.Axis.X) {
                    return powered ? PRESSED_FLOOR_AABB_X : FLOOR_AABB_X;
                }
                return powered ? PRESSED_FLOOR_AABB_Z : FLOOR_AABB_Z;
            }
            case WALL: {
                return switch (dir) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.EAST -> {
                        if (powered) {
                            yield PRESSED_EAST_AABB;
                        }
                        yield EAST_AABB;
                    }
                    case Direction.WEST -> {
                        if (powered) {
                            yield PRESSED_WEST_AABB;
                        }
                        yield WEST_AABB;
                    }
                    case Direction.SOUTH -> {
                        if (powered) {
                            yield PRESSED_SOUTH_AABB;
                        }
                        yield SOUTH_AABB;
                    }
                    case Direction.NORTH, Direction.UP, Direction.DOWN -> powered ? PRESSED_NORTH_AABB : NORTH_AABB;
                };
            }
        }
        if (dir.m_122434_() == Direction.Axis.X) {
            return powered ? PRESSED_CEILING_AABB_X : CEILING_AABB_X;
        }
        return powered ? PRESSED_CEILING_AABB_Z : CEILING_AABB_Z;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(state, level, pos);
        this.playSound(player, (LevelAccessor)level, pos, true);
        level.m_142346_((Entity)player, GameEvent.f_223702_, pos);
        BlockPos targetPos = pos.m_121955_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_().m_122436_());
        Block target = level.m_8055_(targetPos).m_60734_();
        if (target instanceof BlockController) {
            BlockController controller = (BlockController)target;
            controller.toggle(level, targetPos, player, this.keyType);
        } else if (target instanceof BlockSlave) {
            BlockSlave slave = (BlockSlave)target;
            slave.toggle(level, targetPos, player, this.keyType);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void press(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(state, level, pos);
        level.m_186460_(pos, (Block)this, 10);
    }

    protected void playSound(@Nullable Player player, LevelAccessor level, BlockPos pos, boolean clickOn) {
        level.m_5594_((Player)(clickOn ? player : null), pos, this.getSound(clickOn), SoundSource.BLOCKS, 0.3f, clickOn ? 0.6f : 0.5f);
    }

    protected SoundEvent getSound(boolean clickOn) {
        return clickOn ? SoundEvents.f_12632_ : SoundEvents.f_12631_;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(state, (Level)level, pos);
        }
    }

    protected void checkPressed(BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateNeighbours(state, level, pos);
            this.playSound(null, (LevelAccessor)level, pos, false);
            level.m_142346_(null, GameEvent.f_223703_, pos);
        }
    }

    private void updateNeighbours(BlockState state, Level level, BlockPos pos) {
        level.m_46672_(pos, (Block)this);
        level.m_46672_(pos.m_121945_(BlockKeyButton.m_53200_((BlockState)state).m_122424_()), (Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, POWERED, f_53179_});
    }
}

