/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockDrawers
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    private static final VoxelShape AABB_NORTH_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_SOUTH_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_WEST_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_EAST_FULL = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape AABB_NORTH_HALF = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH_HALF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape AABB_WEST_HALF = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_EAST_HALF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private final int drawerCount;
    private final boolean halfDepth;
    private final int storageUnits;
    public final AABB[] slotGeometry;
    public final AABB[] countGeometry;
    public final AABB[] labelGeometry;
    public final AABB[] indGeometry;
    public final AABB[] indBaseGeometry;
    private long ignoreEventTime;

    public BlockDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.storageUnits = storageUnits;
        this.slotGeometry = new AABB[drawerCount];
        this.countGeometry = new AABB[drawerCount];
        this.labelGeometry = new AABB[drawerCount];
        this.indGeometry = new AABB[drawerCount];
        this.indBaseGeometry = new AABB[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.slotGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.countGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.labelGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indBaseGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public boolean retrimBlock(Level world, BlockPos pos, ItemStack prototype) {
        return false;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public int getDrawerCount() {
        return this.drawerCount;
    }

    public boolean isHalfDepth() {
        return this.halfDepth;
    }

    public int getStorageUnits() {
        return this.storageUnits;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch (direction) {
            case EAST: {
                return this.halfDepth ? AABB_EAST_HALF : AABB_EAST_FULL;
            }
            case WEST: {
                return this.halfDepth ? AABB_WEST_HALF : AABB_WEST_FULL;
            }
            case SOUTH: {
                return this.halfDepth ? AABB_SOUTH_HALF : AABB_SOUTH_FULL;
            }
        }
        return this.halfDepth ? AABB_NORTH_HALF : AABB_NORTH_FULL;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        IDrawerAttributes _attrs;
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        CompoundTag tag = stack.m_41737_("tile");
        if (tag != null) {
            blockEntity.readPortable(tag);
        }
        ItemKey key = null;
        if (entity != null) {
            Item item = entity.m_21206_().m_41720_();
            if (item instanceof ItemKey) {
                ItemKey itemKey;
                key = itemKey = (ItemKey)item;
            } else {
                item = entity.m_21206_().m_41720_();
                if (item instanceof ItemKeyring) {
                    ItemKeyring itemKeyring = (ItemKeyring)item;
                    key = itemKeyring.getKey().m_41720_();
                }
            }
        }
        if (key != null && (_attrs = (IDrawerAttributes)blockEntity.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY).orElse((Object)new EmptyDrawerAttributes())) instanceof IDrawerAttributesModifiable) {
            IDrawerAttributesModifiable attrs = (IDrawerAttributesModifiable)_attrs;
            if (key == ModItems.DRAWER_KEY.get()) {
                attrs.setItemLocked(LockAttribute.LOCK_EMPTY, true);
                attrs.setItemLocked(LockAttribute.LOCK_POPULATED, true);
            } else if (key == ModItems.QUANTIFY_KEY.get()) {
                attrs.setIsShowingQuantity(true);
            } else if (key == ModItems.SHROUD_KEY.get()) {
                attrs.setIsConcealed(true);
            }
        }
    }

    protected final int getDrawerSlot(@NotNull BlockState state, @NotNull BlockHitResult hit) {
        Direction side = hit.m_82434_();
        if (state.m_61143_((Property)f_54117_) != side) {
            return -1;
        }
        return this.getDrawerSlot(hit.m_82434_(), BlockDrawers.normalizeHitVec(hit.m_82450_()));
    }

    @NotNull
    private static Vec3 normalizeHitVec(@NotNull Vec3 hit) {
        return new Vec3((hit.f_82479_ < 0.0 ? hit.f_82479_ - Math.floor(hit.f_82479_) : hit.f_82479_) % 1.0, (hit.f_82480_ < 0.0 ? hit.f_82480_ - Math.floor(hit.f_82480_) : hit.f_82480_) % 1.0, (hit.f_82481_ < 0.0 ? hit.f_82481_ - Math.floor(hit.f_82481_) : hit.f_82481_) % 1.0);
    }

    protected int getDrawerSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        return -1;
    }

    protected boolean hitAny(Direction side, Vec3 normalizedHit) {
        if (side == Direction.NORTH || side == Direction.SOUTH) {
            return 0.0625 < normalizedHit.f_82479_ && normalizedHit.f_82479_ < 0.9375 && 0.0625 < normalizedHit.f_82480_ && normalizedHit.f_82480_ < 0.9375;
        }
        if (side == Direction.EAST || side == Direction.WEST) {
            return 0.0625 < normalizedHit.f_82481_ && normalizedHit.f_82481_ < 0.9375 && 0.0625 < normalizedHit.f_82480_ && normalizedHit.f_82480_ < 0.9375;
        }
        return false;
    }

    protected boolean hitTop(@NotNull Vec3 normalizedHit) {
        return normalizedHit.f_82480_ > 0.5;
    }

    protected boolean hitLeft(Direction side, @NotNull Vec3 normalizedHit) {
        return switch (side) {
            case Direction.NORTH -> {
                if (normalizedHit.f_82479_ > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (normalizedHit.f_82479_ < 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (normalizedHit.f_82481_ < 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (normalizedHit.f_82481_ > 0.5) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemStack item = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_ && Util.m_137550_() == this.ignoreEventTime) {
            this.ignoreEventTime = 0L;
            return InteractionResult.PASS;
        }
        boolean invertClick = (Boolean)ClientConfig.GENERAL.invertClick.get();
        if (!invertClick) {
            return this.insertOrApplyItem(state, level, pos, player, hit);
        }
        this.interactTakeItems(state, level, pos, player, hit);
        return InteractionResult.SUCCESS;
    }

    public void m_6256_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player) {
        BlockHitResult hit = WorldUtils.rayTraceEyes(level, player, blockPos);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (!hit.m_82425_().equals((Object)blockPos)) {
            return;
        }
        boolean invertClick = (Boolean)ClientConfig.GENERAL.invertClick.get();
        if (invertClick) {
            this.insertOrApplyItem(state, level, blockPos, player, hit);
        } else {
            this.interactTakeItems(state, level, blockPos, player, hit);
        }
    }

    public InteractionResult insertOrApplyItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        int slot;
        ItemStack item = player.m_21120_(InteractionHand.MAIN_HAND);
        final BlockEntityDrawers blockEntityDrawers = WorldUtils.getBlockEntity((BlockGetter)level, blockPos, BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return InteractionResult.FAIL;
        }
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("BlockDrawers.onBlockActivated");
            StorageDrawers.log.info((String)(item.m_41619_() ? "  null item" : "  " + item.toString()));
        }
        if (!item.m_41619_()) {
            if (item.m_41720_() instanceof ItemKey || item.m_41720_() instanceof ItemKeyring) {
                return InteractionResult.PASS;
            }
            if (item.m_41720_() instanceof ItemUpgrade) {
                if (!blockEntityDrawers.upgrades().canAddUpgrade(item)) {
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.storagedrawers.cannot_add_upgrade"), true);
                    }
                    return InteractionResult.PASS;
                }
                if (!blockEntityDrawers.upgrades().addUpgrade(item)) {
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.storagedrawers.max_upgrades"), true);
                    }
                    return InteractionResult.PASS;
                }
                level.m_7260_(blockPos, state, state, 3);
                if (!player.m_7500_()) {
                    item.m_41774_(1);
                    if (item.m_41613_() <= 0) {
                        player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (item.m_41619_() && player.m_6144_() && ((Boolean)CommonConfig.GENERAL.enableUI.get()).booleanValue() && !level.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return Component.m_237115_((String)BlockDrawers.this.m_7705_());
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInv, @NotNull Player playerEntity) {
                    if (BlockDrawers.this.drawerCount == 1) {
                        return new ContainerDrawers1(windowId, playerInv, blockEntityDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 2) {
                        return new ContainerDrawers2(windowId, playerInv, blockEntityDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 4) {
                        return new ContainerDrawers4(windowId, playerInv, blockEntityDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 3 && BlockDrawers.this instanceof BlockCompDrawers) {
                        return new ContainerDrawersComp(windowId, playerInv, blockEntityDrawers);
                    }
                    return null;
                }
            }, extraData -> extraData.m_130064_(blockPos));
            return InteractionResult.SUCCESS;
        }
        if ((slot = this.getDrawerSlot(state, hit)) < 0) {
            return InteractionResult.PASS;
        }
        blockEntityDrawers.interactPutItemsIntoSlot(slot, player);
        if (item.m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean interactTakeItems(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("onBlockClicked");
        }
        if (!(state.m_60734_() instanceof BlockDrawers)) {
            return false;
        }
        BlockEntityDrawers blockEntityDrawers = WorldUtils.getBlockEntity((BlockGetter)level, blockPos, BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return false;
        }
        if (level.m_8055_(blockPos) != state) {
            return false;
        }
        int slot = this.getDrawerSlot(state, hit);
        if (slot < 0) {
            return false;
        }
        IDrawer drawer = blockEntityDrawers.getDrawer(slot);
        boolean invertShift = (Boolean)ClientConfig.GENERAL.invertShift.get();
        ItemStack item = player.m_6144_() != invertShift ? blockEntityDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : blockEntityDrawers.takeItemsFromSlot(slot, 1);
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info((String)(item.m_41619_() ? "  null item" : "  " + item));
        }
        if (!item.m_41619_()) {
            if (!player.m_150109_().m_36054_(item)) {
                this.dropItemStack(level, blockPos.m_121945_(hit.m_82434_()), player, item);
                level.m_7260_(blockPos, state, state, 3);
            } else {
                level.m_5594_(null, blockPos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        return true;
    }

    private void dropItemStack(@NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.3f), (double)((float)pos.m_123343_() + 0.5f), stack);
        Vec3 motion = entity.m_20184_();
        entity.m_5997_(-motion.f_82479_, -motion.f_82480_, -motion.f_82481_);
        world.m_7967_((Entity)entity);
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (BlockEntityDrawers)builder.m_78982_(LootContextParams.f_81462_)));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, BlockEntityDrawers tile) {
        int i;
        ItemStack drop = new ItemStack((ItemLike)this);
        if (tile == null) {
            return drop;
        }
        CompoundTag data = drop.m_41783_();
        if (data == null) {
            data = new CompoundTag();
        }
        boolean hasContents = false;
        for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer.isEmpty()) continue;
            hasContents = true;
        }
        for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
            if (tile.upgrades().getUpgrade(i).m_41619_()) continue;
            hasContents = true;
        }
        if (hasContents) {
            CompoundTag tiledata = tile.m_187482_();
            data.m_128365_("tile", (Tag)tiledata);
            drop.m_41751_(data);
        }
        return drop;
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return (Boolean)CommonConfig.GENERAL.enableAnalogRedstone.get() == false;
    }

    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        if (!this.m_7899_(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity(blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public int m_6376_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull Direction side) {
        return side == Direction.UP ? this.m_6378_(state, worldIn, pos, side) : 0;
    }

    public void m_6810_(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.m_60713_(p_51541_.m_60734_())) {
            p_51539_.m_46717_(p_51540_, (Block)this);
            super.m_6810_(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level blockAccess, BlockPos pos) {
        if (!this.m_7278_(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public boolean m_7923_(@NotNull BlockState state) {
        return true;
    }
}

