/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.forge.terraform.boat.impl.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.cristelknight.doapi.client.terraform.TerraformBoatClientHelper;
import de.cristelknight.doapi.forge.terraform.boat.api.TerraformBoatTypeRegistry;
import de.cristelknight.doapi.forge.terraform.boat.impl.entity.TerraformBoatHolder;
import de.cristelknight.doapi.terraform.boat.TerraformBoatType;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;

public class TerraformBoatEntityRenderer
extends BoatRenderer {
    private final Map<TerraformBoatType, Pair<ResourceLocation, BoatModel>> texturesAndModels;

    public TerraformBoatEntityRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context, chest);
        String prefix = chest ? "chest_boat/" : "boat/";
        this.texturesAndModels = (Map)TerraformBoatTypeRegistry.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, entry -> {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            ResourceLocation textureId = new ResourceLocation(id.m_135827_(), "textures/entity/" + prefix + id.m_135815_() + ".png");
            ModelLayerLocation layer = TerraformBoatClientHelper.getLayer(id, chest);
            BoatModel model = new BoatModel(context.m_174023_(layer), chest);
            return new Pair((Object)textureId, (Object)model);
        }));
    }

    public void m_7392_(Boat boat, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        if (boat instanceof TerraformBoatHolder) {
            TerraformBoatHolder holder = (TerraformBoatHolder)boat;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.375, 0.0);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - f));
            float h = (float)boat.m_38385_() - g;
            float j = boat.m_38384_() - g;
            if (j < 0.0f) {
                j = 0.0f;
            }
            if (h > 0.0f) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)boat.m_38386_()));
            }
            if (!Mth.m_14033_((float)boat.m_38352_(g), (float)0.0f)) {
                poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), boat.m_38352_(g), true));
            }
            Pair<ResourceLocation, BoatModel> pair = this.getTextureAndModel(holder);
            ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
            BoatModel boatModel = (BoatModel)pair.getSecond();
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            boatModel.m_6973_(boat, g, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(boatModel.m_103119_(resourceLocation));
            boatModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (!boat.m_5842_()) {
                VertexConsumer vertexConsumer2 = multiBufferSource.m_6299_(RenderType.m_110478_());
                boatModel.m_102282_().m_104301_(poseStack, vertexConsumer2, i, OverlayTexture.f_118083_);
            }
            poseStack.m_85849_();
        } else {
            super.m_7392_(boat, f, g, poseStack, multiBufferSource, i);
        }
    }

    public ResourceLocation m_5478_(Boat entity) {
        if (entity instanceof TerraformBoatHolder) {
            TerraformBoatType boat = ((TerraformBoatHolder)entity).getTerraformBoat();
            return (ResourceLocation)this.texturesAndModels.get(boat).getFirst();
        }
        return super.m_5478_(entity);
    }

    public Pair<ResourceLocation, BoatModel> getTextureAndModel(TerraformBoatHolder holder) {
        return this.texturesAndModels.get(holder.getTerraformBoat());
    }
}

