/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.map.WorldMapSession;
import xaero.map.gui.MySmallButton;
import xaero.map.gui.ScreenBase;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapWorld;

public class GuiMapTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private EditBox commandFormatTextField;
    private EditBox dimensionCommandFormatTextField;
    private String commandFormat;
    private String dimensionCommandFormat;
    private Component waypointCommandHint = Component.m_237115_((String)"gui.xaero_wm_teleport_command_waypoints_hint");

    public GuiMapTpCommand(Screen parent, Screen escape) {
        super(parent, escape, (Component)Component.m_237115_((String)"gui.xaero_wm_teleport_command"));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        if (this.commandFormat == null) {
            this.commandFormat = mapWorld.getTeleportCommandFormat();
        }
        if (this.dimensionCommandFormat == null) {
            this.dimensionCommandFormat = mapWorld.getDimensionTeleportCommandFormat();
        }
        this.commandFormatTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 20, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_wm_teleport_command"));
        this.commandFormatTextField.m_94199_(128);
        this.commandFormatTextField.m_94144_(this.commandFormat);
        this.dimensionCommandFormatTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 50, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_wm_dimension_teleport_command"));
        this.dimensionCommandFormatTextField.m_94199_(256);
        this.dimensionCommandFormatTextField.m_94144_(this.dimensionCommandFormat);
        this.m_7787_(this.commandFormatTextField);
        this.m_7787_(this.dimensionCommandFormatTextField);
        if (SupportMods.minimap()) {
            this.m_142416_((GuiEventListener)new MySmallButton(this.f_96543_ / 2 - 75, this.f_96544_ / 7 + 118, (Component)Component.m_237115_((String)"gui.xaero_wm_teleport_command_waypoints"), b -> SupportMods.xaeroMinimap.openWaypointWorldTeleportCommandScreen(this, this.escape)));
        }
        this.confirmButton = new MySmallButton(this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)Component.m_237115_((String)"gui.xaero_confirm"), b -> {
            this.updateFormat();
            if (this.canConfirm()) {
                mapWorld.setTeleportCommandFormat(this.commandFormat);
                mapWorld.setDimensionTeleportCommandFormat(this.dimensionCommandFormat);
                mapWorld.saveConfig();
                this.goBack();
            }
        });
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)new MySmallButton(this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)Component.m_237115_((String)"gui.xaero_cancel"), b -> this.goBack()));
        this.f_96541_.f_91068_.m_90926_(true);
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(matrixStack, mouseX, mouseY, partial);
        this.m_7333_(matrixStack);
        GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        if (SupportMods.minimap()) {
            GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.waypointCommandHint, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 104), (int)-5592406);
        }
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"{x} {y} {z} {d}", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 6), (int)-5592406);
        super.m_6305_(matrixStack, mouseX, mouseY, partial);
        this.commandFormatTextField.m_6305_(matrixStack, mouseX, mouseY, partial);
        this.dimensionCommandFormatTextField.m_6305_(matrixStack, mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0 && this.dimensionCommandFormat != null && this.dimensionCommandFormat.length() > 0;
    }

    private void updateFormat() {
        this.commandFormat = this.commandFormatTextField.m_94155_();
        this.dimensionCommandFormat = this.dimensionCommandFormatTextField.m_94155_();
    }

    public void m_86600_() {
        this.commandFormatTextField.m_94120_();
        this.dimensionCommandFormatTextField.m_94120_();
        this.updateFormat();
        this.confirmButton.f_93623_ = this.canConfirm();
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        if (par1 == 257 && this.commandFormat != null && this.commandFormat.length() > 0) {
            this.confirmButton.m_5716_(0.0, 0.0);
        }
        return super.m_7933_(par1, par2, par3);
    }

    public void m_7522_(GuiEventListener l) {
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).m_94178_(false);
        }
        super.m_7522_(l);
    }
}

