/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnEntityDamageBlocked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class RepulsionEnchantment
extends Handler {
    float strength = 1.0f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.UNCOMMON).category(MajruszsEnchantments.IS_SHIELD).slots((List)EquipmentSlots.HANDS).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public RepulsionEnchantment() {
        super(MajruszsEnchantments.REPULSION, RepulsionEnchantment.class, false);
        OnEntityDamageBlocked.listen(this::knockback).addCondition(Condition.isLogicalServer()).addCondition(data -> data.source.m_7639_() == data.source.m_7640_()).addCondition(data -> data.attacker != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)ItemHelper.getCurrentlyUsedItem((LivingEntity)data.target)));
        this.config.define("knockback_strength", Reader.number(), s -> Float.valueOf(this.strength), (s, v) -> {
            this.strength = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(100.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void knockback(OnEntityDamageBlocked data) {
        data.attacker.m_147240_((double)this.strength, (double)Mth.m_14031_((float)(data.attacker.m_146908_() * (float)Math.PI / 180.0f + (float)Math.PI)), (double)(-Mth.m_14089_((float)(data.attacker.m_146908_() * (float)Math.PI / 180.0f + (float)Math.PI))));
    }
}

