/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.map;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.JsonDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.forge.MapDataInternalImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MapDataInternal {
    public static final ResourceLocation GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final Map<ResourceLocation, CustomDecorationType<?, ?>> CODE_TYPES_FACTORIES = new HashMap();
    public static final Codec<MapDecorationType<?, ?>> CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    public static final Codec<MapDecorationType<?, ?>> NETWORK_CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.NETWORK_CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    @ApiStatus.Internal
    public static final Map<ResourceLocation, CustomMapData.Type<?>> CUSTOM_MAP_DATA_TYPES = new LinkedHashMap();
    private static final List<TriFunction<Player, Integer, MapItemSavedData, Set<MapBlockMarker<?>>>> DYNAMIC_SERVER = new ArrayList();
    private static final List<BiFunction<Integer, MapItemSavedData, Set<MapBlockMarker<?>>>> DYNAMIC_CLIENT = new ArrayList();

    public static <T extends CustomMapData<?>> CustomMapData.Type<T> registerCustomMapSavedData(CustomMapData.Type<T> type) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(type.id())) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + type.id());
        }
        CUSTOM_MAP_DATA_TYPES.put(type.id(), type);
        return type;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceKey<Registry<MapDecorationType<?, ?>>> getRegistryKey() {
        return MapDataInternalImpl.getRegistryKey();
    }

    public static MapDecorationType<?, ?> getGenericStructure() {
        return MapDataInternal.get(GENERIC_STRUCTURE_ID);
    }

    public static <T extends CustomDecorationType<?, ?>> T registerCustomType(T decorationType) {
        CODE_TYPES_FACTORIES.put(decorationType.getCustomFactoryID(), decorationType);
        return decorationType;
    }

    public static CustomDecorationType<?, ?> getCustomType(ResourceLocation resourceLocation) {
        return Objects.requireNonNull(CODE_TYPES_FACTORIES.get(resourceLocation), "No map decoration type with id: " + resourceLocation);
    }

    public static MapDecorationType<?, ?> getAssociatedType(Holder<Structure> structure) {
        for (MapDecorationType<?, ?> v : MapDataInternal.getValues()) {
            Optional<HolderSet<Structure>> associatedStructure = v.getAssociatedStructure();
            if (!associatedStructure.isPresent() || !associatedStructure.get().m_203333_(structure)) continue;
            return v;
        }
        return MapDataInternal.getGenericStructure();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDataInternalImpl.init();
    }

    public static Registry<MapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().m_175515_(MapDataInternal.getRegistryKey());
    }

    public static Registry<MapDecorationType<?, ?>> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(MapDataInternal.getRegistryKey());
    }

    public static Collection<MapDecorationType<?, ?>> getValues() {
        return MapDataInternal.hackyGetRegistry().m_123024_().toList();
    }

    public static Set<Map.Entry<ResourceKey<MapDecorationType<?, ?>>, MapDecorationType<?, ?>>> getEntries() {
        return MapDataInternal.hackyGetRegistry().m_6579_();
    }

    @Nullable
    public static MapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return MapDataInternal.get(new ResourceLocation(id));
    }

    public static MapDecorationType<?, ?> get(ResourceLocation id) {
        Registry<MapDecorationType<?, ?>> reg = MapDataInternal.hackyGetRegistry();
        MapDecorationType r = (MapDecorationType)reg.m_7745_(id);
        if (r == null) {
            return (MapDecorationType)reg.m_7745_(GENERIC_STRUCTURE_ID);
        }
        return r;
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(ResourceLocation id) {
        return MapDataInternal.hackyGetRegistry().m_6612_(id);
    }

    public static Set<MapBlockMarker<?>> getDynamicServer(Player player, int mapId, MapItemSavedData data) {
        HashSet dynamic = new HashSet();
        for (TriFunction<Player, Integer, MapItemSavedData, Set<MapBlockMarker<?>>> v : DYNAMIC_SERVER) {
            dynamic.addAll((Collection)v.apply(player, mapId, data));
        }
        return dynamic;
    }

    public static Set<MapBlockMarker<?>> getDynamicClient(int mapId, MapItemSavedData data) {
        HashSet dynamic = new HashSet();
        for (BiFunction<Integer, MapItemSavedData, Set<MapBlockMarker<?>>> v : DYNAMIC_CLIENT) {
            dynamic.addAll((Collection)v.apply(mapId, data));
        }
        return dynamic;
    }

    @Nullable
    public static MapBlockMarker<?> readWorldMarker(CompoundTag compound) {
        Iterator iterator = compound.m_128431_().iterator();
        if (iterator.hasNext()) {
            String id = (String)iterator.next();
            return MapDataInternal.get(new ResourceLocation(id)).loadMarkerFromNBT(compound.m_128469_(id));
        }
        return null;
    }

    public static List<MapBlockMarker<?>> getMarkersFromWorld(BlockGetter reader, BlockPos pos) {
        ArrayList list = new ArrayList();
        for (MapDecorationType<?, ?> type : MapDataInternal.getValues()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }

    public static void addDynamicClientMarkersEvent(BiFunction<Integer, MapItemSavedData, Set<MapBlockMarker<?>>> event) {
        DYNAMIC_CLIENT.add(event);
    }

    public static void addDynamicServerMarkersEvent(TriFunction<Player, Integer, MapItemSavedData, Set<MapBlockMarker<?>>> event) {
        DYNAMIC_SERVER.add(event);
    }
}

