/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.registry.RegistryClass;
import net.valhelsia.valhelsia_core.core.registry.RegistryManager;

public class RegistryHelper<T> {
    private RegistryManager registryManager = null;
    private DeferredRegister<T> deferredRegister = null;
    private final List<Supplier<RegistryClass>> registryClasses;

    @SafeVarargs
    public RegistryHelper(Supplier<RegistryClass> ... registryClasses) {
        this.registryClasses = ImmutableList.copyOf((Object[])registryClasses);
    }

    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    public void setup(RegistryManager registryManager) {
        this.registryManager = registryManager;
        this.deferredRegister = DeferredRegister.create((ResourceLocation)Objects.requireNonNull((ResourceKey)this.getRegistryManager().registryHelpers().inverse().get((Object)this)).m_135782_(), (String)this.getRegistryManager().modId());
    }

    public Set<RegistryObject<T>> getRegistryObjects() {
        return ImmutableSet.copyOf((Collection)this.deferredRegister.getEntries());
    }

    public List<Supplier<RegistryClass>> getRegistryClasses() {
        return this.registryClasses;
    }

    public void registerDeferredRegister(IEventBus eventBus) {
        this.deferredRegister.register(eventBus);
    }

    public <O extends T> RegistryObject<O> register(String name, Supplier<O> object) {
        return this.registerInternal(name, object);
    }

    public <O extends T> RegistryObject<O> registerInternal(String name, Supplier<O> object) {
        return this.deferredRegister.register(name, object);
    }
}

