/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.data;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.registry.RegistryManager;

public abstract class ValhelsiaItemModelProvider
extends ItemModelProvider {
    private final Set<RegistryObject<Item>> remainingItems;
    private final Set<RegistryObject<Item>> remainingBlockItems;

    public ValhelsiaItemModelProvider(DataGenerator generator, RegistryManager registryManager, ExistingFileHelper existingFileHelper) {
        super(generator, registryManager.modId(), existingFileHelper);
        this.remainingItems = registryManager.getItemHelper().getRegistryObjects().stream().filter(item -> !(item.get() instanceof BlockItem)).collect(Collectors.toSet());
        this.remainingBlockItems = registryManager.getItemHelper().getRegistryObjects().stream().filter(item -> item.get() instanceof BlockItem).collect(Collectors.toSet());
    }

    public Set<RegistryObject<Item>> getRemainingItems() {
        return this.remainingItems;
    }

    public Set<RegistryObject<Item>> getRemainingBlockItems() {
        return this.remainingBlockItems;
    }

    public void forEachItem(Predicate<Item> predicate, Consumer<Item> consumer) {
        Iterator<RegistryObject<Item>> iterator = this.getRemainingItems().iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next().get();
            if (!predicate.test(item)) continue;
            consumer.accept(item);
            iterator.remove();
        }
    }

    public void forEachItem(Consumer<Item> consumer) {
        Iterator<RegistryObject<Item>> iterator = this.getRemainingItems().iterator();
        while (iterator.hasNext()) {
            consumer.accept((Item)iterator.next().get());
            iterator.remove();
        }
    }

    public void forEachBlockItem(Predicate<BlockItem> predicate, Consumer<BlockItem> consumer) {
        Iterator<RegistryObject<Item>> iterator = this.getRemainingBlockItems().iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next().get();
            if (!predicate.test((BlockItem)item)) continue;
            consumer.accept((BlockItem)item);
            iterator.remove();
        }
    }

    public void forEachBlockItem(Consumer<BlockItem> consumer) {
        Iterator<RegistryObject<Item>> iterator = this.getRemainingBlockItems().iterator();
        while (iterator.hasNext()) {
            consumer.accept((BlockItem)iterator.next().get());
            iterator.remove();
        }
    }

    @SafeVarargs
    public final <T extends Item> void takeItem(Consumer<T> consumer, RegistryObject<? extends Item> ... items) {
        for (RegistryObject<? extends Item> item : items) {
            consumer.accept((Item)item.get());
            this.getRemainingItems().remove(item);
        }
    }

    public final void takeBlockItem(Consumer<BlockItem> consumer, RegistryObject<?> ... registryObjects) {
        for (RegistryObject<?> registryObject : registryObjects) {
            BlockItem item;
            Object object = registryObject.get();
            if (object instanceof Block) {
                Block block = (Block)object;
                item = (BlockItem)block.m_5456_();
            } else {
                item = (BlockItem)registryObject.get();
            }
            consumer.accept(item);
            this.getRemainingBlockItems().remove(RegistryObject.create((ResourceLocation)ForgeRegistries.ITEMS.getKey((Object)item), (IForgeRegistry)ForgeRegistries.ITEMS));
        }
    }

    public <T extends Item> void simpleModel(T item) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", "item/" + name);
    }

    public <T extends Item> void simpleModelBlockTexture(T item) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_();
        this.simpleModelBlockTexture(item, name);
    }

    public <T extends Item> void simpleModelBlockTexture(T item, String texture) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", "block/" + texture);
    }

    public <T extends Item> void withParent(T item) {
        this.withParent(item, false);
    }

    public <T extends Item> void withParent(T item, boolean mcLoc) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_();
        this.withParent(item, name, mcLoc);
    }

    public <T extends Item> void withParent(T item, String loc) {
        this.withParent(item, loc, false);
    }

    public <T extends Item> void withParent(T item, String loc, boolean mcLoc) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_();
        this.withExistingParent(name, mcLoc ? this.mcLoc("block/" + loc) : this.modLoc("block/" + loc));
    }

    public <T extends Item> void withParentInventory(T item) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_();
        this.withExistingParent(name, this.modLoc("block/" + name + "_inventory"));
    }
}

