/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics.source;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticKey;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticType;
import net.valhelsia.valhelsia_core.client.util.TextureDownloader;

public abstract class CosmeticsSource {
    private final List<CosmeticType> types = new ObjectArrayList();
    private final Map<String, Map<String, ResourceLocation>> loadedTextures = new HashMap<String, Map<String, ResourceLocation>>();
    private final String name;

    public CosmeticsSource(String name) {
        this.name = name;
    }

    public abstract List<CosmeticKey> loadCosmeticsFor(UUID var1);

    public void loadTexturesInternal(CosmeticKey key) {
        this.loadedTextures.put(key.name(), new HashMap());
        this.loadTextures(key);
    }

    public abstract void loadTextures(CosmeticKey var1);

    public final void registerTexture(CosmeticKey key, String name, ResourceLocation location) {
        this.loadedTextures.get(key.name()).put(name, location);
    }

    public final void registerMainTexture(CosmeticKey key, ResourceLocation location) {
        this.loadedTextures.get(key.name()).put(key.name(), location);
    }

    public final void downloadTexture(CosmeticKey key, String name, String url) {
        TextureDownloader.downloadTextureNoFallback(url, "cosmetics/", texture -> this.registerTexture(key, name, texture));
    }

    public final void downloadMainTexture(CosmeticKey key, String url) {
        TextureDownloader.downloadTextureNoFallback(url, "cosmetics/", texture -> this.registerMainTexture(key, texture));
    }

    public final boolean texturesLoaded(CosmeticKey key) {
        return this.loadedTextures.containsKey(key.name());
    }

    public final Map<String, ResourceLocation> getTextures(CosmeticKey key) {
        return this.loadedTextures.get(key.name());
    }

    public final String getName() {
        return this.name;
    }

    public final void addType(CosmeticType type) {
        this.types.add(type);
    }

    public final List<CosmeticType> getTypes() {
        return this.types;
    }
}

