/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticKey;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;

public class ActiveCosmeticsStorage {
    public static final ActiveCosmeticsStorage EMPTY = new ActiveCosmeticsStorage().setImmutable();
    private Map<CosmeticsCategory, CosmeticKey> activeCosmetics = new EnumMap<CosmeticsCategory, CosmeticKey>(CosmeticsCategory.class);

    public void set(CosmeticsCategory category, CosmeticKey key) {
        this.activeCosmetics.put(category, key);
    }

    public void set(CompoundTag activeCosmetics) {
        for (CosmeticsCategory category : CosmeticsCategory.values()) {
            if (!activeCosmetics.m_128441_(category.getName())) continue;
            CompoundTag tag = activeCosmetics.m_128469_(category.getName());
            CosmeticKey key = CosmeticKey.of(tag);
            if (key == null) {
                this.remove(category);
                continue;
            }
            this.set(category, CosmeticKey.of(tag));
        }
    }

    public Optional<CosmeticKey> get(CosmeticsCategory category) {
        if (this.activeCosmetics.containsKey((Object)category)) {
            return Optional.of(this.activeCosmetics.get((Object)category));
        }
        return Optional.empty();
    }

    public void remove(CosmeticsCategory category) {
        this.activeCosmetics.remove((Object)category);
    }

    private ActiveCosmeticsStorage setImmutable() {
        this.activeCosmetics = Maps.immutableEnumMap(new EnumMap(CosmeticsCategory.class));
        return this;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public CompoundTag writeToTag(CompoundTag tag) {
        if (this.isEmpty()) {
            return tag;
        }
        for (CosmeticsCategory category : CosmeticsCategory.values()) {
            this.get(category).ifPresent(key -> tag.m_128365_(category.getName(), (Tag)key.writeToTag(new CompoundTag())));
        }
        return tag;
    }
}

