/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.shadowizardlib.network;

import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.mindoth.shadowizardlib.network.MessageHelper;
import net.mindoth.shadowizardlib.network.MessageProvider;
import net.mindoth.shadowizardlib.network.PacketDistro;
import net.mindoth.shadowizardlib.network.ShadowizardNetwork;
import net.mindoth.shadowizardlib.util.ThanksList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SupporterDisableMessage
implements MessageProvider<SupporterDisableMessage> {
    private int type;
    private UUID id;

    public SupporterDisableMessage(int type) {
        this.type = type;
    }

    public SupporterDisableMessage(int type, UUID id) {
        this(type);
        this.id = id;
    }

    @Override
    public void encode(SupporterDisableMessage message, FriendlyByteBuf buffer) {
        buffer.writeByte(message.type);
        buffer.writeByte(message.id == null ? 0 : 1);
        if (message.id != null) {
            buffer.m_130077_(message.id);
        }
    }

    @Override
    public SupporterDisableMessage decode(FriendlyByteBuf buffer) {
        byte type = buffer.readByte();
        if (buffer.readByte() == 1) {
            return new SupporterDisableMessage(type, buffer.m_130259_());
        }
        return new SupporterDisableMessage(type);
    }

    @Override
    public void handle(SupporterDisableMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            MessageHelper.handlePacket(() -> () -> SupporterDisableMessage.lambda$handle$0(message, (Supplier)contextSupplier), contextSupplier);
        } else {
            MessageHelper.handlePacket(() -> () -> {
                Set<UUID> set = ThanksList.DISABLED;
                if (set.contains(message.id) || set.contains(message.id) && message.type == 1) {
                    set.remove(message.id);
                } else if (message.type == 0) {
                    set.add(message.id);
                }
            }, contextSupplier);
        }
    }

    private static /* synthetic */ void lambda$handle$0(SupporterDisableMessage message, Supplier contextSupplier) {
        PacketDistro.sendToAll(ShadowizardNetwork.CHANNEL, new SupporterDisableMessage(message.type, ((NetworkEvent.Context)contextSupplier.get()).getSender().m_20148_()));
    }
}

