/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.shadowizardlib.event;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ItemAttributeModifierEvent;

public class CommonEvents {
    public static Vec3 getEntityCenter(Entity entity) {
        return entity.m_20191_().m_82399_();
    }

    public static List<Entity> getEntitiesAround(Entity center, double x, double y, double z) {
        List targets = center.f_19853_.m_45933_(center, center.m_20191_().m_82377_(x, y, z));
        return targets;
    }

    public static void findAndRemoveVanillaModifier(ItemAttributeModifierEvent event, Attribute attribute, UUID baseUUID) {
        event.getOriginalModifiers().get((Object)attribute).stream().filter(modifier -> modifier.m_22209_() == baseUUID).findAny().ifPresent(modifier -> event.removeModifier(attribute, modifier));
    }

    public static ArrayList<LivingEntity> getEntitiesAround(Entity caster, Level pLevel, double size) {
        ArrayList targets = (ArrayList)pLevel.m_45976_(LivingEntity.class, caster.m_20191_().m_82400_(size));
        targets.removeIf(entry -> entry == caster || !entry.m_6097_() || !entry.m_6084_() && (!(entry instanceof Player) || !((Player)entry).m_150110_().f_35937_));
        return targets;
    }

    public static Entity getNearestEntity(Entity player, Level pLevel, double size) {
        ArrayList<LivingEntity> targets = CommonEvents.getEntitiesAround(player, pLevel, size);
        LivingEntity target = null;
        double lowestSoFar = Double.MAX_VALUE;
        for (LivingEntity closestSoFar : targets) {
            double testDistance;
            if (closestSoFar.m_7307_(player) || !((testDistance = (double)player.m_20270_((Entity)closestSoFar)) < lowestSoFar)) continue;
            target = closestSoFar;
        }
        return target;
    }

    public static Entity getPointedEntity(Level level, Entity caster, float range, float error, boolean isPlayer) {
        int adjuster = 1;
        if (!isPlayer) {
            adjuster = -1;
        }
        Vec3 direction = CommonEvents.calculateViewVector(caster.m_146909_() * (float)adjuster, caster.m_146908_() * (float)adjuster).m_82541_();
        direction = direction.m_82542_((double)range, (double)range, (double)range);
        Vec3 center = caster.m_146892_().m_82549_(direction);
        Entity returnEntity = caster;
        double playerX = CommonEvents.getEntityCenter((Entity)caster).f_82479_;
        double playerY = CommonEvents.getEntityCenter((Entity)caster).f_82480_;
        double playerZ = CommonEvents.getEntityCenter((Entity)caster).f_82481_;
        double listedEntityX = center.m_7096_();
        double listedEntityY = center.m_7098_();
        double listedEntityZ = center.m_7094_();
        int particleInterval = (int)Math.round(caster.m_20238_(center));
        for (int k = 1; k < 1 + particleInterval; ++k) {
            double lineX = playerX * (1.0 - (double)k / (double)particleInterval) + listedEntityX * ((double)k / (double)particleInterval);
            double lineY = playerY * (1.0 - (double)k / (double)particleInterval) + listedEntityY * ((double)k / (double)particleInterval);
            double lineZ = playerZ * (1.0 - (double)k / (double)particleInterval) + listedEntityZ * ((double)k / (double)particleInterval);
            Vec3 start = new Vec3(lineX + (double)error, lineY + (double)error, lineZ + (double)error);
            Vec3 end = new Vec3(lineX - (double)error, lineY - (double)error, lineZ - (double)error);
            AABB area = new AABB(start, end);
            List targets = level.m_45933_(caster, area);
            Entity target = null;
            double lowestSoFar = Double.MAX_VALUE;
            for (Entity closestSoFar : targets) {
                double testDistance;
                if (!(closestSoFar instanceof LivingEntity) || !((testDistance = closestSoFar.m_20238_(center)) < lowestSoFar)) continue;
                target = closestSoFar;
            }
            if (target == null) continue;
            returnEntity = target;
            break;
        }
        return returnEntity;
    }

    public static Vec3 calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

