/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.datagen.BlockStateGenerationHelper;
import lilypuree.decorative_blocks.registration.BlockRegistryObject;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DBBlockStates
extends BlockStateProvider {
    public DBBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    private ModelBuilder<?> createModel(IWoodType wood, WoodDecorativeBlockTypes type) {
        return this.createModel(wood, type, null);
    }

    private ModelBuilder<?> createModel(IWoodType wood, WoodDecorativeBlockTypes type, String suffix) {
        String name = type + (String)(suffix == null ? "" : "_" + suffix);
        return ((BlockModelBuilder)this.models().getBuilder(wood + "_" + name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/" + name)));
    }

    private ModelBuilder<?> withParticleTexture(ModelBuilder<?> model, String name) {
        ResourceLocation texture = this.modLoc("block/" + name);
        return model.texture("particle", texture).texture("texture", texture);
    }

    private ModelBuilder<?> withSideEndTextures(ModelBuilder<?> model, String name) {
        ResourceLocation side = this.modLoc("block/" + name + "_side");
        ResourceLocation end = this.modLoc("block/" + name + "_end");
        return model.texture("particle", side).texture("side", side).texture("end", end);
    }

    protected void registerStatesAndModels() {
        BlockStateGenerationHelper generationHelper = new BlockStateGenerationHelper("decorative_blocks", this);
        for (VanillaWoodTypes wood : VanillaWoodTypes.values()) {
            generationHelper.beamBlock((IWoodenBlock)((BlockRegistryObject)DBBlocks.BEAMS.get((Object)wood)).get());
            generationHelper.palisadeBlock((IWoodenBlock)((BlockRegistryObject)DBBlocks.PALISADES.get((Object)wood)).get());
            generationHelper.seatBlock((IWoodenBlock)((BlockRegistryObject)DBBlocks.SEATS.get((Object)wood)).get());
            generationHelper.supportBlock((IWoodenBlock)((BlockRegistryObject)DBBlocks.SUPPORTS.get((Object)wood)).get());
        }
        ModelBuilder builder = ((BlockModelBuilder)this.models().getBuilder("bar_panel_bottom")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bar_panel_bottom")));
        ModelBuilder<?> barPanelBottomModel = this.withSideEndTextures(builder, "bar_panel");
        builder = ((BlockModelBuilder)this.models().getBuilder("bar_panel_top")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bar_panel_top")));
        ModelBuilder<?> barPanelTopModel = this.withSideEndTextures(builder, "bar_panel");
        builder = ((BlockModelBuilder)this.models().getBuilder("bar_panel_open")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bar_panel_open")));
        ModelBuilder<?> barPanelOpenModel = this.withSideEndTextures(builder, "bar_panel");
        this.trapdoorBlock((TrapDoorBlock)DBBlocks.BAR_PANEL.get(), (ModelFile)barPanelBottomModel, (ModelFile)barPanelTopModel, (ModelFile)barPanelOpenModel, true);
    }
}

