/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.mixin;

import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.entity.EntityNoiseListener;
import com.majruszlibrary.events.OnEntityNoiseCheck;
import com.majruszlibrary.events.OnEntityNoiseReceived;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.mixininterfaces.IMixinEntity;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IMixinEntity {
    private static final String majruszlibrary$TAG_ID = "MajruszLibrary";
    @Shadow
    private Level f_19853_;
    private VibrationListener.VibrationListenerConfig majruszlibrary$vibrationConfig = null;
    private DynamicGameEventListener<VibrationListener> majruszlibrary$vibrationListener = null;
    private int majruszlibrary$glowTicks = 0;
    private int majruszlibrary$invisibleTicks = 0;
    private CompoundTag majruszlibrary$extraTag = null;

    @Inject(at={@At(value="TAIL")}, method={"<init> (Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"})
    private void constructor(EntityType<?> type, Level level, CallbackInfo callback) {
        Entity entity = (Entity)this;
        if (EntityNoiseListener.isSupported(entity.getClass())) {
            this.majruszlibrary$vibrationConfig = new Config(entity);
            this.majruszlibrary$vibrationListener = new DynamicGameEventListener((GameEventListener)new VibrationListener((PositionSource)new EntityPositionSource(entity, entity.m_20192_()), 16, this.majruszlibrary$vibrationConfig, null, 0.0f, 0));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick ()V"})
    private void tick(CallbackInfo callback) {
        MixinEntity mixinEntity;
        this.majruszlibrary$glowTicks = Math.max(this.majruszlibrary$glowTicks - 1, 0);
        this.majruszlibrary$invisibleTicks = Math.max(this.majruszlibrary$invisibleTicks - 1, 0);
        if (this.majruszlibrary$vibrationConfig != null && !this.f_19853_.f_46443_) {
            ((VibrationListener)this.majruszlibrary$vibrationListener.m_223616_()).m_157898_(this.f_19853_);
        }
        if ((mixinEntity = this) instanceof IAnimableEntity) {
            IAnimableEntity animable = (IAnimableEntity)((Object)mixinEntity);
            animable.getAnimations().tick();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"updateDynamicGameEventListener (Ljava/util/function/BiConsumer;)V"})
    private void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer, CallbackInfo callback) {
        Level level;
        if (this.majruszlibrary$vibrationListener != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            consumer.accept(this.majruszlibrary$vibrationListener, level2);
        }
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"isCurrentlyGlowing ()Z"})
    private void isCurrentlyGlowing(CallbackInfoReturnable<Boolean> callback) {
        callback.setReturnValue((Object)((Boolean)callback.getReturnValue() != false || this.majruszlibrary$glowTicks > 0 ? 1 : 0));
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"isInvisible ()Z"})
    private void isInvisible(CallbackInfoReturnable<Boolean> callback) {
        callback.setReturnValue((Object)((Boolean)callback.getReturnValue() != false || this.majruszlibrary$invisibleTicks > 0 ? 1 : 0));
    }

    @Inject(at={@At(value="RETURN")}, method={"saveWithoutId (Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"})
    private void saveWithoutId(CompoundTag tag, CallbackInfoReturnable<CompoundTag> callback) {
        if (this.majruszlibrary$extraTag != null) {
            tag.m_128365_(majruszlibrary$TAG_ID, (Tag)this.majruszlibrary$extraTag);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"load (Lnet/minecraft/nbt/CompoundTag;)V"})
    private void load(CompoundTag tag, CallbackInfo callback) {
        if (tag.m_128441_(majruszlibrary$TAG_ID)) {
            this.majruszlibrary$extraTag = tag.m_128469_(majruszlibrary$TAG_ID);
        }
    }

    @Override
    public void majruszlibrary$addGlowTicks(int ticks) {
        this.majruszlibrary$glowTicks += ticks;
    }

    @Override
    public void majruszlibrary$addInvisibleTicks(int ticks) {
        this.majruszlibrary$invisibleTicks += ticks;
    }

    @Override
    public int majruszlibrary$getInvisibleTicks() {
        return this.majruszlibrary$invisibleTicks;
    }

    @Override
    @Nullable
    public CompoundTag majruszlibrary$getExtraTag() {
        return this.majruszlibrary$extraTag;
    }

    @Override
    public CompoundTag majruszlibrary$getOrCreateExtraTag() {
        if (this.majruszlibrary$extraTag == null) {
            this.majruszlibrary$extraTag = new CompoundTag();
        }
        return this.majruszlibrary$extraTag;
    }

    public static class Config
    implements VibrationListener.VibrationListenerConfig {
        final Entity entity;

        Config(Entity entity) {
            this.entity = entity;
        }

        public boolean m_213641_(ServerLevel level, GameEventListener listener, BlockPos position, GameEvent event, GameEvent.Context context) {
            return Events.dispatch(new OnEntityNoiseCheck(level, position, this.entity)).isAudible();
        }

        public void m_213991_(ServerLevel level, GameEventListener listener, BlockPos position, GameEvent event, @Nullable Entity owner, @Nullable Entity ownersProjectile, float distance) {
            Events.dispatch(new OnEntityNoiseReceived(level, position, this.entity, owner, ownersProjectile, distance));
        }

        public TagKey<GameEvent> m_213929_() {
            return GameEventTags.f_215853_;
        }
    }
}

