/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.math;

import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Side;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.RandomSource;

public class Random {
    static final RandomSource CLIENT = RandomSource.m_216327_();
    static final RandomSource SERVER = RandomSource.m_216327_();

    public static RandomSource getThreadSafe() {
        return Side.isLogicalClient() ? CLIENT : SERVER;
    }

    public static float nextFloat() {
        return Random.getThreadSafe().m_188501_();
    }

    public static float nextFloat(float min, float max) {
        return (max - min) * Random.nextFloat() + min;
    }

    public static float nextFloat(Range<Float> range) {
        return Random.nextFloat(((Float)range.from).floatValue(), ((Float)range.to).floatValue());
    }

    public static double nextDouble() {
        return Random.getThreadSafe().m_188500_();
    }

    public static double nextDouble(double min, double max) {
        return (max - min) * Random.nextDouble() + min;
    }

    public static double nextDouble(Range<Double> range) {
        return Random.nextDouble((Double)range.from, (Double)range.to);
    }

    public static double nextGaussian() {
        return Random.getThreadSafe().m_188583_();
    }

    public static int nextInt() {
        return Random.getThreadSafe().m_188502_();
    }

    public static int nextInt(int max) {
        return Random.getThreadSafe().m_188503_(max);
    }

    public static int nextInt(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            return max + Random.nextInt(min - max);
        }
        return min + Random.nextInt(max - min);
    }

    public static int nextInt(Range<Integer> range) {
        return Random.nextInt((Integer)range.from, (Integer)range.to);
    }

    public static int nextSign() {
        return Random.nextBoolean() ? 1 : -1;
    }

    public static boolean nextBoolean() {
        return Random.getThreadSafe().m_188499_();
    }

    public static AnyPos nextVector(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        return AnyPos.from(Float.valueOf(Random.nextFloat(minX, maxX)), Float.valueOf(Random.nextFloat(minY, maxY)), Float.valueOf(Random.nextFloat(minZ, maxZ)));
    }

    public static AnyPos nextVector(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        return AnyPos.from(Random.nextDouble(minX, maxX), Random.nextDouble(minY, maxY), Random.nextDouble(minZ, maxZ));
    }

    public static AnyPos nextVector(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return AnyPos.from(Random.nextInt(minX, maxX), Random.nextInt(minY, maxY), Random.nextInt(minZ, maxZ));
    }

    public static AnyPos nextUnitVector() {
        AnyPos pos = Random.nextVector(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        return pos.len().doubleValue() < 1.0E-5 ? Random.nextUnitVector() : pos.norm();
    }

    public static <Type> Type next(Type ... elements) {
        return elements.length > 0 ? (Type)elements[Random.nextInt(elements.length)] : null;
    }

    public static <Type> Type next(List<Type> elements) {
        return elements.size() > 0 ? (Type)elements.get(Random.nextInt(elements.size())) : null;
    }

    public static <Type> List<Type> next(List<Type> elements, int count) {
        return Random.getRandomIndices(elements.size()).stream().limit(count).map(elements::get).toList();
    }

    public static <Type> Type next(Set<Type> elements) {
        return (Type)Random.next(elements.toArray());
    }

    public static <Type1, Type2> Map.Entry<Type1, Type2> next(Map<Type1, Type2> elements) {
        return Random.next(elements.entrySet());
    }

    public static boolean check(float chance) {
        return Random.nextFloat() < chance;
    }

    public static boolean check(double chance) {
        return Random.nextDouble() < chance;
    }

    public static int round(double value) {
        int roundedValue;
        return roundedValue + (Random.check(value - (double)(roundedValue = (int)value)) ? 1 : 0);
    }

    private static List<Integer> getRandomIndices(int size) {
        List<Integer> indices = IntStream.iterate(0, i -> i + 1).limit(size).boxed().collect(Collectors.toList());
        Collections.shuffle(indices);
        return indices;
    }
}

