/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.entity;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeHandler {
    final UUID uuid;
    final String name;
    final Supplier<Attribute> attribute;
    final AttributeModifier.Operation operation;
    double value = 0.0;

    public AttributeHandler(String uuid, String name, Supplier<Attribute> attribute, AttributeModifier.Operation operation) {
        this.uuid = UUID.fromString(uuid);
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
    }

    public AttributeHandler(String name, Supplier<Attribute> attribute, AttributeModifier.Operation operation) {
        this.uuid = UUID.nameUUIDFromBytes(name.getBytes());
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
    }

    public boolean hasAttribute(LivingEntity entity) {
        return entity.m_21204_().m_22171_(this.attribute.get());
    }

    public boolean hasValueChanged(AttributeInstance attributeInstance) {
        AttributeModifier modifier = attributeInstance.m_22111_(this.uuid);
        return modifier == null || modifier.m_22218_() != this.value;
    }

    public double getValue() {
        return this.value;
    }

    public AttributeHandler setValue(double value) {
        this.value = value;
        return this;
    }

    public AttributeHandler apply(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.m_21051_(this.attribute.get());
        if (attributeInstance != null && this.hasValueChanged(attributeInstance)) {
            attributeInstance.m_22120_(this.uuid);
            attributeInstance.m_22118_(this.createAttribute());
        }
        return this;
    }

    public AttributeHandler remove(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.m_21051_(this.attribute.get());
        if (attributeInstance != null) {
            attributeInstance.m_22120_(this.uuid);
        }
        return this;
    }

    public AttributeModifier createAttribute() {
        return new AttributeModifier(this.uuid, this.name, this.value, this.operation);
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

