/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.common;

import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.text.TextHelper;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BonusComponent<Type extends Item> {
    protected final BonusHandler<Type> handler;
    final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();

    public BonusComponent(BonusHandler<Type> handler) {
        this.handler = handler;
    }

    public BonusComponent<Type> addTooltip(final String key, final ITooltipProvider ... providers) {
        this.tooltipProviders.add(new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                return TextHelper.translatable((String)key, (Object[])Stream.of(providers).map(provider -> provider.getTooltip(holder)).toArray());
            }

            @Override
            public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
                return TextHelper.translatable((String)key, (Object[])Stream.of(providers).map(provider -> provider.getDetailedTooltip(holder)).toArray());
            }

            @Override
            public MutableComponent getRangeTooltip(AccessoryHolder holder) {
                return TextHelper.translatable((String)key, (Object[])Stream.of(providers).map(provider -> provider.getRangeTooltip(holder)).toArray());
            }
        });
        return this;
    }

    public List<ITooltipProvider> getTooltipProviders() {
        return Collections.unmodifiableList(this.tooltipProviders);
    }

    protected void addToGeneratedLoot(OnLootGenerated data) {
        data.generatedLoot.add((Object)this.constructItemStack());
    }

    protected void replaceGeneratedLoot(OnLootGenerated data) {
        data.generatedLoot.clear();
        data.generatedLoot.add((Object)this.constructItemStack());
    }

    protected void spawnFlyingItem(Level level, Vec3 from, Vec3 to) {
        LevelHelper.spawnItemEntityFlyingTowardsDirection((ItemStack)this.constructItemStack(), (Level)level, (Vec3)from, (Vec3)to);
    }

    protected void spawnFlyingItem(Level level, Vec3 position) {
        LevelHelper.spawnItemEntityFlyingTowardsDirection((ItemStack)this.constructItemStack(), (Level)level, (Vec3)position, (Vec3)AnyPos.from((Vec3)position).add((Number)0.0, (Number)1.0, (Number)0.0).vec3());
    }

    protected ItemStack constructItemStack() {
        AccessoryHolder holder = AccessoryHolder.create(this.handler.getItem());
        if (holder.isValid()) {
            holder.setRandomBonus();
        }
        return holder.getItemStack();
    }

    protected Type getItem() {
        return this.handler.getItem();
    }

    @FunctionalInterface
    public static interface ISupplier<Type extends Item> {
        public BonusComponent<Type> apply(BonusHandler<Type> var1);
    }
}

