/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnAnimalTamed;
import com.majruszlibrary.events.OnBabySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.level.Level;

public class TamingStrongerAnimals
extends BonusComponent<AccessoryItem> {
    final AttributeHandler health;
    final AttributeHandler damage;
    final AttributeHandler speed;
    final AttributeHandler jumpHeight;
    RangedFloat bonus = new RangedFloat().id("bonus").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float bonus) {
        return handler -> new TamingStrongerAnimals(handler, bonus);
    }

    protected TamingStrongerAnimals(BonusHandler<AccessoryItem> handler, float bonus) {
        super(handler);
        this.health = new AttributeHandler("%s_health_multiplier".formatted(handler.getId()), () -> Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_BASE);
        this.damage = new AttributeHandler("%s_damage_multiplier".formatted(handler.getId()), () -> Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE);
        this.speed = new AttributeHandler("%s_speed_multiplier".formatted(handler.getId()), () -> Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE);
        this.jumpHeight = new AttributeHandler("%s_jump_height_multiplier".formatted(handler.getId()), () -> Attributes.f_22288_, AttributeModifier.Operation.MULTIPLY_BASE);
        this.bonus.set(bonus, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        OnAnimalTamed.listen(this::applyBonuses).addCondition(Condition.isLogicalServer());
        OnBabySpawned.listen(this::applyBonuses).addCondition(Condition.isLogicalServer()).addCondition(data -> this.hasModifier((LivingEntity)data.parentA) || this.hasModifier((LivingEntity)data.parentB));
        this.addTooltip("majruszsaccessories.bonuses.animal_attributes", TooltipHelper.asPercent(this.bonus));
        handler.getConfig().define("animal_bonus", this.bonus::define);
    }

    private void applyBonuses(OnAnimalTamed data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.tamer).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        this.applyBonuses(holder.apply(this.bonus), (LivingEntity)data.animal);
        this.spawnEffects(data, holder);
    }

    private void applyBonuses(OnBabySpawned data) {
        this.applyBonuses((float)Math.max(this.getModifierValue((LivingEntity)data.parentA), this.getModifierValue((LivingEntity)data.parentB)), (LivingEntity)data.child);
    }

    private void applyBonuses(float bonus, LivingEntity entity) {
        this.health.setValue((double)bonus).apply(entity);
        if (this.damage.hasAttribute(entity)) {
            this.damage.setValue((double)bonus).apply(entity);
        }
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.jumpHeight.setValue((double)bonus).apply((LivingEntity)horse);
            this.speed.setValue((double)bonus).apply((LivingEntity)horse);
        }
        entity.m_21153_(entity.m_21233_());
    }

    private void spawnEffects(OnAnimalTamed data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(4).sizeBased((Entity)data.animal).emit((Level)data.getServerLevel());
    }

    private double getModifierValue(LivingEntity entity) {
        return entity.m_21204_().m_22173_(Attributes.f_22276_, this.health.getUUID());
    }

    private boolean hasModifier(LivingEntity entity) {
        return entity.m_21204_().m_22154_(Attributes.f_22276_, this.health.getUUID());
    }
}

