/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.SerializableObject;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnItemBrewed;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class StrongerPotions
extends BonusComponent<AccessoryItem> {
    RangedFloat durationPenalty = new RangedFloat().id("duration_penalty").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
    RangedFloat amplifier = new RangedFloat().id("amplifier").maxRange((Range<Float>)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(20.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float durationPenalty, float amplifier) {
        return handler -> new StrongerPotions(handler, durationPenalty, amplifier);
    }

    protected StrongerPotions(BonusHandler<AccessoryItem> handler, float durationPenalty, float amplifier) {
        super(handler);
        this.durationPenalty.set(durationPenalty, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        this.amplifier.set(amplifier, (Range<Float>)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(10.0f)));
        OnItemBrewed.listen(this::boostPotions).addCondition(data -> data.items.subList(0, 3).stream().anyMatch(itemStack -> !PotionUtils.m_43547_((ItemStack)itemStack).isEmpty()));
        this.addTooltip("majruszsaccessories.bonuses.potion_amplifier", TooltipHelper.asValue(this.amplifier).scaleOnlyOnDetailed());
        this.addTooltip("majruszsaccessories.bonuses.potion_duration", TooltipHelper.asPercent(this.durationPenalty).bonusMultiplier(-1.0f));
        handler.getConfig().define("stronger_potion", subconfig -> {
            this.durationPenalty.define((SerializableObject<?>)subconfig);
            this.amplifier.define((SerializableObject<?>)subconfig);
        });
    }

    private void boostPotions(OnItemBrewed data) {
        Player player = LevelHelper.getNearestPlayer((Level)data.level, (BlockPos)data.blockPos, (float)10.0f);
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        data.mapPotions(potions -> {
            float durationMultiplier = 1.0f - holder.apply(this.durationPenalty, -1.0f);
            int extraAmplifier = Math.round(holder.apply(this.amplifier));
            return potions.stream().map(itemStack -> {
                List effects = PotionUtils.m_43547_((ItemStack)itemStack);
                if (effects.isEmpty()) {
                    return itemStack;
                }
                ItemStack potion = new ItemStack((ItemLike)itemStack.m_41720_());
                Serializables.write((Object)new Data(), (Tag)potion.m_41784_());
                return PotionUtils.m_43552_((ItemStack)potion, PotionUtils.m_43547_((ItemStack)itemStack).stream().map(effect -> new MobEffectInstance(effect.m_19544_(), Math.max(40, (int)((float)effect.m_19557_() * durationMultiplier)), effect.m_19564_() + extraAmplifier)).toList());
            }).toList();
        });
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnItemBrewed data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(6).position(AnyPos.from((BlockPos)data.blockPos).center().vec3()).emit((Level)data.getServerLevel());
    }

    private static class Data {
        private String name = "{\"translate\":\"majruszsaccessories.bonuses.potion_name\",\"italic\":false}";

        private Data() {
        }

        static {
            Serializables.get(Data.class).define("display", config -> config.define("Name", Reader.string(), s -> s.name, (s, v) -> {
                s.name = v;
            }));
        }
    }
}

