/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnFishingTimeGet;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class FishingLureBonus
extends BonusComponent<AccessoryItem> {
    RangedFloat multiplier = new RangedFloat().id("multiplier").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float bonus) {
        return handler -> new FishingLureBonus(handler, bonus);
    }

    protected FishingLureBonus(BonusHandler<AccessoryItem> handler, float bonus) {
        super(handler);
        this.multiplier.set(bonus, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        OnFishingTimeGet.listen(this::decreaseFishingTime);
        this.addTooltip("majruszsaccessories.bonuses.fishing_lure", TooltipHelper.asPercent(this.multiplier));
        handler.getConfig().define("fishing_time", this.multiplier::define);
    }

    private void decreaseFishingTime(OnFishingTimeGet data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        data.time = Math.round((float)data.time * (1.0f - holder.apply(this.multiplier)));
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnFishingTimeGet data, AccessoryHolder holder) {
        BlockPos position = LevelHelper.getPositionOverFluid((Level)data.getLevel(), (BlockPos)data.hook.m_20183_());
        holder.getParticleEmitter().count(4).offset(ParticleEmitter.offset((float)0.125f)).position(AnyPos.from((Number)data.hook.m_20185_(), (Number)((double)position.m_123342_() + 0.25), (Number)data.hook.m_20189_()).vec3()).emit((Level)data.getServerLevel());
    }
}

