/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.events.OnBabySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class BreedingTwins
extends BonusComponent<AccessoryItem> {
    static AgeableMob LAST_CHILD = null;
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);

    public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
        return handler -> new BreedingTwins(handler, chance);
    }

    protected BreedingTwins(BonusHandler<AccessoryItem> handler, float chance) {
        super(handler);
        this.chance.set(chance, (Range<Float>)Range.CHANCE);
        OnBabySpawned.listen(this::spawnTwins).addCondition(Condition.isLogicalServer()).addCondition(data -> data.player != null).addCondition(data -> data.child != LAST_CHILD);
        this.addTooltip("majruszsaccessories.bonuses.spawn_twins", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("breeding_twins", this.chance::define);
    }

    private void spawnTwins(OnBabySpawned data) {
        AccessoryHolder holder = AccessoryHolders.get((LivingEntity)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        LAST_CHILD = data.parentA.m_142606_(data.getServerLevel(), (AgeableMob)data.parentB);
        if (LAST_CHILD == null) {
            return;
        }
        LAST_CHILD.m_6863_(true);
        LAST_CHILD.m_19890_(data.parentA.m_20185_(), data.parentA.m_20186_(), data.parentA.m_20189_(), 0.0f, 0.0f);
        data.getLevel().m_7967_((Entity)LAST_CHILD);
        Events.dispatch((Object)new OnBabySpawned(data.parentA, data.parentB, LAST_CHILD, data.player));
        this.spawnEffects(data, LAST_CHILD, holder);
    }

    private void spawnEffects(OnBabySpawned data, AgeableMob child, AccessoryHolder holder) {
        holder.getParticleEmitter().count(4).sizeBased((Entity)child).emit((Level)data.getServerLevel());
    }
}

