/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.accessories.components.AccessoryIncompatibility;
import com.majruszsaccessories.accessories.components.SwimmingSpeedBonus;
import com.majruszsaccessories.common.AccessoryHandler;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.common.components.TradeOffer;
import com.majruszsaccessories.events.base.CustomConditions;
import com.majruszsaccessories.items.AccessoryItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class SwimmerGuide
extends AccessoryHandler {
    public SwimmerGuide() {
        super(MajruszsAccessories.SWIMMER_GUIDE, SwimmerGuide.class);
        this.add(SwimmingSpeedBonus.create(0.2f)).add(UnderwaterChestDropChance.create()).add(BuriedTreasureDropChance.create()).add(TradeOffer.create()).add(AccessoryIncompatibility.create(MajruszsAccessories.ADVENTURER_RUNE)).add(AccessoryIncompatibility.create(MajruszsAccessories.SOUL_OF_MINECRAFT));
    }

    static class UnderwaterChestDropChance
    extends BonusComponent<AccessoryItem> {
        float chance = 0.05f;

        public static BonusComponent.ISupplier<AccessoryItem> create() {
            return UnderwaterChestDropChance::new;
        }

        protected UnderwaterChestDropChance(BonusHandler<AccessoryItem> handler) {
            super(handler);
            OnLootGenerated.listen(x$0 -> this.addToGeneratedLoot((OnLootGenerated)x$0)).addCondition(Condition.hasLevel()).addCondition(data -> data.origin != null).addCondition(data -> BlockHelper.getState((Level)data.getLevel(), (Vec3)data.origin).m_60819_().m_164512_((Fluid)Fluids.f_76193_)).addCondition(data -> data.lootId.toString().contains("chest")).addCondition(CustomConditions.dropChance(s -> Float.valueOf(this.chance), data -> data.entity));
            handler.getConfig().define("underwater_chest_spawn_chance", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
                this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }
    }

    static class BuriedTreasureDropChance
    extends BonusComponent<AccessoryItem> {
        float chance = 0.25f;

        public static BonusComponent.ISupplier<AccessoryItem> create() {
            return BuriedTreasureDropChance::new;
        }

        protected BuriedTreasureDropChance(BonusHandler<AccessoryItem> handler) {
            super(handler);
            OnLootGenerated.listen(x$0 -> this.addToGeneratedLoot((OnLootGenerated)x$0)).addCondition(Condition.hasLevel()).addCondition(data -> data.origin != null).addCondition(data -> data.lootId.equals((Object)BuiltInLootTables.f_78692_)).addCondition(CustomConditions.dropChance(s -> Float.valueOf(this.chance), data -> data.entity));
            handler.getConfig().define("buried_treasure_spawn_chance", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
                this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }
    }
}

