/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnItemBrewed;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.accessories.components.AccessoryIncompatibility;
import com.majruszsaccessories.accessories.components.StrongerPotions;
import com.majruszsaccessories.common.AccessoryHandler;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.common.components.TradeOffer;
import com.majruszsaccessories.events.base.CustomConditions;
import com.majruszsaccessories.items.AccessoryItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

@AutoInstance
public class SecretIngredient
extends AccessoryHandler {
    public SecretIngredient() {
        super(MajruszsAccessories.SECRET_INGREDIENT, SecretIngredient.class);
        this.add(StrongerPotions.create(0.6f, 1.0f)).add(BrewingDropChance.create()).add(TradeOffer.create()).add(AccessoryIncompatibility.create(MajruszsAccessories.HOUSEHOLD_RUNE)).add(AccessoryIncompatibility.create(MajruszsAccessories.SOUL_OF_MINECRAFT));
    }

    static class BrewingDropChance
    extends BonusComponent<AccessoryItem> {
        float chance = 0.02f;

        public static BonusComponent.ISupplier<AccessoryItem> create() {
            return BrewingDropChance::new;
        }

        protected BrewingDropChance(BonusHandler<AccessoryItem> handler) {
            super(handler);
            OnItemBrewed.listen(this::spawnAccessory).addCondition(CustomConditions.dropChance(s -> Float.valueOf(this.chance), data -> LevelHelper.getNearestPlayer((Level)data.getLevel(), (BlockPos)data.blockPos, (float)30.0f)));
            handler.getConfig().define("brewing_drop_chance", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
                this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }

        private void spawnAccessory(OnItemBrewed data) {
            AnyPos pos = AnyPos.from((BlockPos)data.blockPos).center();
            this.spawnFlyingItem(data.getLevel(), pos.vec3(), pos.add((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f), (Number)Float.valueOf(0.0f)).vec3());
        }
    }
}

