/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.client.widget.SelectionList;
import daripher.skilltree.client.widget.editor.SkillTreeEditor;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.init.PSTSkillBonuses;
import daripher.skilltree.skill.bonus.SkillBonus;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public final class LootDuplicationBonus
implements SkillBonus<LootDuplicationBonus> {
    private LootType lootType;
    private float multiplier;
    private float chance;

    public LootDuplicationBonus(float chance, float multiplier, LootType lootType) {
        this.chance = chance;
        this.multiplier = multiplier;
        this.lootType = lootType;
    }

    @Override
    public SkillBonus.Serializer getSerializer() {
        return (SkillBonus.Serializer)PSTSkillBonuses.LOOT_DUPLICATION.get();
    }

    public LootDuplicationBonus copy() {
        return new LootDuplicationBonus(this.chance, this.multiplier, this.lootType);
    }

    @Override
    public LootDuplicationBonus multiply(double multiplier) {
        this.chance = (float)((double)this.chance * multiplier);
        return this;
    }

    @Override
    public boolean canMerge(SkillBonus<?> other) {
        if (!(other instanceof LootDuplicationBonus)) {
            return false;
        }
        LootDuplicationBonus otherBonus = (LootDuplicationBonus)other;
        if (otherBonus.multiplier != this.multiplier) {
            return false;
        }
        return Objects.equals((Object)otherBonus.lootType, (Object)this.lootType);
    }

    @Override
    public SkillBonus<LootDuplicationBonus> merge(SkillBonus<?> other) {
        if (!(other instanceof LootDuplicationBonus)) {
            throw new IllegalArgumentException();
        }
        LootDuplicationBonus otherBonus = (LootDuplicationBonus)other;
        return new LootDuplicationBonus(otherBonus.chance + this.chance, this.multiplier, this.lootType);
    }

    @Override
    public MutableComponent getTooltip() {
        MutableComponent lootDescription = Component.m_237115_((String)this.lootType.getDescriptionId());
        String multiplierDescription = ItemStack.f_41584_.format(this.multiplier * 100.0f);
        MutableComponent bonusDescription = Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{multiplierDescription, lootDescription});
        return TooltipHelper.getSkillBonusTooltip((Component)bonusDescription, (double)this.chance, AttributeModifier.Operation.MULTIPLY_BASE).m_130948_(TooltipHelper.getSkillBonusStyle(this.isPositive()));
    }

    @Override
    public boolean isPositive() {
        return this.chance > 0.0f;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditor editor, int row, Consumer<LootDuplicationBonus> consumer) {
        editor.addLabel(0, 0, "Chance", ChatFormatting.GOLD);
        editor.addLabel(110, 0, "Multiplier", ChatFormatting.GOLD);
        editor.increaseHeight(19);
        editor.addNumericTextField(0, 0, 90, 14, this.chance).setNumericResponder(value -> this.selectChance(consumer, (Double)value));
        editor.addNumericTextField(110, 0, 90, 14, this.multiplier).setNumericResponder(value -> this.selectMultiplier(consumer, (Double)value));
        editor.increaseHeight(19);
        editor.addLabel(0, 0, "Loot Type", ChatFormatting.GOLD);
        editor.increaseHeight(19);
        SelectionList<LootType> lootTypeSelection = editor.addSelection(0, 0, 200, 3, this.lootType).setNameGetter(LootType::getFormattedName).setResponder(lootType -> this.selectLootType(consumer, (LootType)((Object)lootType)));
        editor.increaseHeight(lootTypeSelection.getMaxDisplayed() * 14 + 5);
    }

    private void selectLootType(Consumer<LootDuplicationBonus> consumer, LootType lootType) {
        this.setLootType(lootType);
        consumer.accept(this.copy());
    }

    private void selectMultiplier(Consumer<LootDuplicationBonus> consumer, Double value) {
        this.setMultiplier(value.floatValue());
        consumer.accept(this.copy());
    }

    private void selectChance(Consumer<LootDuplicationBonus> consumer, Double value) {
        this.setChance(value.floatValue());
        consumer.accept(this.copy());
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public void setLootType(LootType lootType) {
        this.lootType = lootType;
    }

    public float getChance() {
        return this.chance;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public LootType getLootType() {
        return this.lootType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LootDuplicationBonus that = (LootDuplicationBonus)o;
        if (Float.compare(this.multiplier, that.multiplier) != 0) {
            return false;
        }
        if (Float.compare(this.chance, that.chance) != 0) {
            return false;
        }
        return this.lootType == that.lootType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lootType, Float.valueOf(this.multiplier), Float.valueOf(this.chance)});
    }

    public static enum LootType {
        MOBS("mobs"),
        FISHING("fishing"),
        GEMS("gems");

        final String name;

        private LootType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Component getFormattedName() {
            return Component.m_237113_((String)(this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1)));
        }

        public static LootType byName(String name) {
            for (LootType type : LootType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return MOBS;
        }

        public String getDescriptionId() {
            return "loot.type." + this.getName();
        }
    }

    public static class Serializer
    implements SkillBonus.Serializer {
        @Override
        public LootDuplicationBonus deserialize(JsonObject json) throws JsonParseException {
            float chance = SerializationHelper.getElement(json, "chance").getAsFloat();
            float multiplier = SerializationHelper.getElement(json, "multiplier").getAsFloat();
            LootType lootType = LootType.byName(json.get("loot_type").getAsString());
            return new LootDuplicationBonus(chance, multiplier, lootType);
        }

        @Override
        public void serialize(JsonObject json, SkillBonus<?> bonus) {
            if (!(bonus instanceof LootDuplicationBonus)) {
                throw new IllegalArgumentException();
            }
            LootDuplicationBonus aBonus = (LootDuplicationBonus)bonus;
            json.addProperty("chance", (Number)Float.valueOf(aBonus.chance));
            json.addProperty("multiplier", (Number)Float.valueOf(aBonus.multiplier));
            json.addProperty("loot_type", aBonus.lootType.name);
        }

        @Override
        public LootDuplicationBonus deserialize(CompoundTag tag) {
            float chance = tag.m_128457_("chance");
            float multiplier = tag.m_128457_("multiplier");
            LootType lootType = LootType.byName(tag.m_128461_("loot_type"));
            return new LootDuplicationBonus(chance, multiplier, lootType);
        }

        @Override
        public CompoundTag serialize(SkillBonus<?> bonus) {
            if (!(bonus instanceof LootDuplicationBonus)) {
                throw new IllegalArgumentException();
            }
            LootDuplicationBonus aBonus = (LootDuplicationBonus)bonus;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("chance", aBonus.chance);
            tag.m_128350_("multiplier", aBonus.multiplier);
            tag.m_128359_("loot_type", aBonus.lootType.name);
            return tag;
        }

        @Override
        public LootDuplicationBonus deserialize(FriendlyByteBuf buf) {
            return new LootDuplicationBonus(buf.readFloat(), buf.readFloat(), LootType.byName(buf.m_130277_()));
        }

        @Override
        public void serialize(FriendlyByteBuf buf, SkillBonus<?> bonus) {
            if (!(bonus instanceof LootDuplicationBonus)) {
                throw new IllegalArgumentException();
            }
            LootDuplicationBonus aBonus = (LootDuplicationBonus)bonus;
            buf.writeFloat(aBonus.chance);
            buf.writeFloat(aBonus.multiplier);
            buf.m_130070_(aBonus.lootType.name);
        }

        @Override
        public SkillBonus<?> createDefaultInstance() {
            return new LootDuplicationBonus(0.05f, 1.0f, LootType.MOBS);
        }
    }
}

