/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.client.widget.editor.SkillTreeEditor;
import daripher.skilltree.init.PSTItemBonuses;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public final class PotionAmplificationBonus
implements ItemBonus<PotionAmplificationBonus> {
    private float chance;

    public PotionAmplificationBonus(float chance) {
        this.chance = chance;
    }

    @Override
    public void itemCrafted(ItemStack stack) {
        if (this.chance % 1.0f != 0.0f) {
            ItemHelper.removeItemBonus(stack, this);
            Random random = new Random();
            if (random.nextFloat() < this.chance % 1.0f) {
                ItemHelper.addItemBonus(stack, new PotionAmplificationBonus(1 + (int)this.chance));
            } else {
                ItemHelper.addItemBonus(stack, new PotionAmplificationBonus((int)this.chance));
            }
        }
    }

    @Override
    public boolean canMerge(ItemBonus<?> other) {
        if (!(other instanceof PotionAmplificationBonus)) {
            return false;
        }
        PotionAmplificationBonus otherBonus = (PotionAmplificationBonus)other;
        return this.chance == otherBonus.chance;
    }

    @Override
    public PotionAmplificationBonus merge(ItemBonus<?> other) {
        if (!(other instanceof PotionAmplificationBonus)) {
            throw new IllegalArgumentException();
        }
        PotionAmplificationBonus otherBonus = (PotionAmplificationBonus)other;
        return new PotionAmplificationBonus(this.chance + otherBonus.chance);
    }

    @Override
    public PotionAmplificationBonus copy() {
        return new PotionAmplificationBonus(this.chance);
    }

    @Override
    public PotionAmplificationBonus multiply(double multiplier) {
        return new PotionAmplificationBonus((float)(multiplier * multiplier));
    }

    @Override
    public ItemBonus.Serializer getSerializer() {
        return (ItemBonus.Serializer)PSTItemBonuses.POTION_AMPLIFICATION.get();
    }

    @Override
    public MutableComponent getTooltip() {
        return TooltipHelper.getSkillBonusTooltip(this.getDescriptionId(), (double)this.chance, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    @Override
    public boolean isPositive() {
        return this.chance > 0.0f;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditor editor, int index, Consumer<ItemBonus<?>> consumer) {
        editor.addLabel(0, 0, "Chance", ChatFormatting.GREEN);
        editor.increaseHeight(19);
        editor.addNumericTextField(0, 0, 50, 14, this.getChance()).setNumericResponder(value -> this.selectChance(consumer, (Double)value));
        editor.increaseHeight(19);
    }

    private void selectChance(Consumer<ItemBonus<?>> consumer, Double value) {
        this.setChance(value.floatValue());
        consumer.accept(this);
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public float getChance() {
        return this.chance;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PotionAmplificationBonus that = (PotionAmplificationBonus)obj;
        return Float.floatToIntBits(this.chance) == Float.floatToIntBits(that.chance);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.chance));
    }

    public static class Serializer
    implements ItemBonus.Serializer {
        @Override
        public ItemBonus<?> deserialize(JsonObject json) throws JsonParseException {
            float chance = json.get("chance").getAsFloat();
            return new PotionAmplificationBonus(chance);
        }

        @Override
        public void serialize(JsonObject json, ItemBonus<?> bonus) {
            if (!(bonus instanceof PotionAmplificationBonus)) {
                throw new IllegalArgumentException();
            }
            PotionAmplificationBonus aBonus = (PotionAmplificationBonus)bonus;
            json.addProperty("chance", (Number)Float.valueOf(aBonus.chance));
        }

        @Override
        public ItemBonus<?> deserialize(CompoundTag tag) {
            float chance = tag.m_128457_("chance");
            return new PotionAmplificationBonus(chance);
        }

        @Override
        public CompoundTag serialize(ItemBonus<?> bonus) {
            if (!(bonus instanceof PotionAmplificationBonus)) {
                throw new IllegalArgumentException();
            }
            PotionAmplificationBonus aBonus = (PotionAmplificationBonus)bonus;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("chance", aBonus.chance);
            return tag;
        }

        @Override
        public ItemBonus<?> deserialize(FriendlyByteBuf buf) {
            return new PotionAmplificationBonus(buf.readFloat());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, ItemBonus<?> bonus) {
            if (!(bonus instanceof PotionAmplificationBonus)) {
                throw new IllegalArgumentException();
            }
            PotionAmplificationBonus aBonus = (PotionAmplificationBonus)bonus;
            buf.writeFloat(aBonus.chance);
        }

        @Override
        public ItemBonus<?> createDefaultInstance() {
            return new PotionAmplificationBonus(0.1f);
        }
    }
}

