/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item.gem.loot;

import daripher.skilltree.SkillTreeMod;
import daripher.skilltree.config.Config;
import daripher.skilltree.skill.bonus.SkillBonusHandler;
import daripher.skilltree.skill.bonus.player.LootDuplicationBonus;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="skilltree")
public class GemLootHandler {
    @SubscribeEvent
    public static void dropGemFromOre(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!GemLootHandler.canDropGem(event, player)) {
            return;
        }
        ServerLevel level = (ServerLevel)player.f_19853_;
        LootTable lootTable = GemLootHandler.getGemsLootTable(level);
        LootContext lootContext = GemLootHandler.createGemsLootContext(event, level, player);
        float multiplier = GemLootHandler.getGemLootMultiplier(player);
        if (player.m_217043_().m_188501_() < multiplier % 1.0f) {
            multiplier += 1.0f;
        }
        ObjectArrayList foundGems = lootTable.m_230922_(lootContext);
        for (int i = 0; i < (int)multiplier; ++i) {
            foundGems.stream().map(ItemStack::m_41777_).forEach(s -> Block.m_49840_((Level)level, (BlockPos)event.getPos(), (ItemStack)s));
        }
    }

    private static float getGemLootMultiplier(Player player) {
        return 1.0f + SkillBonusHandler.getLootMultiplier(player, LootDuplicationBonus.LootType.GEMS);
    }

    public static int getGemLootWeight(ResourceLocation gemId) {
        if (gemId.m_135815_().contains("vacucite")) {
            return 200;
        }
        int tier = Integer.parseInt(gemId.m_135815_().substring(gemId.m_135815_().length() - 1));
        return switch (tier) {
            case 0 -> 1000;
            case 1 -> 350;
            case 2 -> 100;
            case 3 -> 10;
            default -> 0;
        };
    }

    public static int getGemLootQuality(ResourceLocation gemId) {
        if (gemId.m_135815_().contains("vacucite")) {
            return 1;
        }
        int tier = Integer.parseInt(gemId.m_135815_().substring(gemId.m_135815_().length() - 1));
        return switch (tier) {
            case 0 -> -50;
            case 1 -> -10;
            case 2 -> -1;
            case 4 -> 5;
            case 5 -> 15;
            default -> 0;
        };
    }

    private static boolean canDropGem(BlockEvent.BreakEvent event, Player player) {
        if (player.m_7500_()) {
            return false;
        }
        if (player.m_9236_().f_46443_) {
            return false;
        }
        if (Config.gem_drop_chance == 0.0) {
            return false;
        }
        if (!player.m_9236_().m_8055_(event.getPos()).m_204336_(Tags.Blocks.ORES)) {
            return false;
        }
        if ((double)player.m_217043_().m_188501_() >= Config.gem_drop_chance) {
            return false;
        }
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)event.getState(), (Player)player)) {
            return false;
        }
        return player.m_21205_().getEnchantmentLevel(Enchantments.f_44985_) == 0;
    }

    @NotNull
    private static LootTable getGemsLootTable(ServerLevel serverLevel) {
        String name = SkillTreeMod.apotheosisEnabled() ? "apotheosis_gems" : "gems";
        ResourceLocation id = new ResourceLocation("skilltree", name);
        return serverLevel.m_7654_().m_129898_().m_79217_(id);
    }

    @NotNull
    private static LootContext createGemsLootContext(BlockEvent.BreakEvent event, ServerLevel serverLevel, Player player) {
        return new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81461_, (Object)event.getState()).m_78972_(LootContextParams.f_81455_, (Object)player).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_78963_(player.m_36336_()).m_78975_(LootContextParamSets.f_81421_);
    }
}

