/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item.gem;

import daripher.skilltree.SkillTreeMod;
import daripher.skilltree.compat.apotheosis.ApotheosisCompatibility;
import daripher.skilltree.data.reloader.GemTypesReloader;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.entity.player.PlayerHelper;
import daripher.skilltree.init.PSTCreativeTabs;
import daripher.skilltree.init.PSTItems;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.gem.GemModel;
import daripher.skilltree.item.gem.GemType;
import daripher.skilltree.item.gem.bonus.GemBonusProvider;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class GemItem
extends Item {
    public GemItem() {
        super(new Item.Properties().m_41491_(PSTCreativeTabs.SKILLTREE));
    }

    public void m_6787_(@NotNull CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (!this.m_220152_(category)) {
            return;
        }
        GemTypesReloader.getGemTypes().values().stream().sorted().map(GemItem::getDefaultGemStack).forEach(arg_0 -> items.add(arg_0));
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack stack) {
        String gemId = GemItem.getGemType(stack).id().toString().replace(":", ".");
        return this.m_5524_() + "." + gemId;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        if (SkillTreeMod.apotheosisEnabled()) {
            components.add((Component)Component.m_237115_((String)"gem.disabled").m_130940_(ChatFormatting.RED));
            return;
        }
        MutableComponent gemTooltip = Component.m_237115_((String)"gem.tooltip").m_130940_(ChatFormatting.YELLOW);
        components.add((Component)gemTooltip);
        GemItem.appendItemBonusesTooltips(stack, components);
    }

    private static void appendItemBonusesTooltips(@NotNull ItemStack stack, @NotNull List<Component> components) {
        GemItem.getGemType(stack).bonuses().forEach((c, b) -> {
            Component itemDescription = c.getTooltip();
            MutableComponent bonusDescription = b.getTooltip(stack);
            MutableComponent tooltip = Component.m_237110_((String)"gem_class_format", (Object[])new Object[]{itemDescription, bonusDescription}).m_130940_(ChatFormatting.GRAY);
            components.add((Component)tooltip);
        });
    }

    public static GemType getGemType(ItemStack gemStack) {
        if (!gemStack.m_41782_()) {
            return GemTypesReloader.NO_TYPE;
        }
        ResourceLocation id = new ResourceLocation(gemStack.m_41784_().m_128461_("type"));
        return GemTypesReloader.getGemTypeById(id);
    }

    public static boolean canInsertGem(Player player, ItemStack itemStack, ItemStack gemStack) {
        if (!ItemHelper.canInsertGem(itemStack)) {
            return false;
        }
        GemBonusProvider bonusProvider = GemItem.getGemType(gemStack).getBonusProvider(itemStack);
        if (bonusProvider == null) {
            return false;
        }
        return bonusProvider.canApply(player, itemStack, gemStack);
    }

    public static void insertGem(Player player, ItemStack itemStack, ItemStack gemStack) {
        GemBonusProvider bonusProvider = GemItem.getGemType(gemStack).getBonusProvider(itemStack);
        if (bonusProvider == null) {
            return;
        }
        bonusProvider.addGemBonus(player, itemStack, gemStack);
    }

    public static void addGemBonus(@Nonnull Player player, @Nonnull ItemStack itemStack, @Nonnull ItemStack gemStack, @Nonnull ItemBonus<?> bonus) {
        GemType gemType = GemItem.getGemType(gemStack);
        float gemPower = PlayerHelper.getGemPower(player, itemStack);
        bonus = bonus.copy().multiply(gemPower);
        ListTag bonusesTag = itemStack.m_41784_().m_128437_("gem_bonuses", 10);
        ListTag gemsTag = itemStack.m_41784_().m_128437_("gems", 8);
        CompoundTag bonusTag = new CompoundTag();
        SerializationHelper.serializeItemBonus(bonusTag, bonus);
        bonusesTag.add((Object)bonusTag);
        gemsTag.add((Object)StringTag.m_129297_((String)gemType.id().toString()));
        itemStack.m_41784_().m_128365_("gem_bonuses", (Tag)bonusesTag);
        itemStack.m_41784_().m_128365_("gems", (Tag)gemsTag);
    }

    public static void removeGemBonuses(ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        stack.m_41784_().m_128473_("gem_bonuses");
        stack.m_41784_().m_128473_("gems");
    }

    public static boolean hasGem(ItemStack stack, int socket) {
        return GemItem.getGemBonuses(stack).size() > socket;
    }

    public static ItemStack getDefaultGemStack(GemType gemType) {
        ItemStack gemStack = new ItemStack((ItemLike)PSTItems.GEM.get());
        gemStack.m_41784_().m_128359_("type", gemType.id().toString());
        return gemStack;
    }

    public static List<? extends ItemBonus<?>> getGemBonuses(ItemStack stack) {
        if (SkillTreeMod.apotheosisEnabled()) {
            return ApotheosisCompatibility.INSTANCE.getGemBonuses(stack);
        }
        if (!stack.m_41782_()) {
            return List.of();
        }
        return stack.m_41784_().m_128437_("gem_bonuses", 10).stream().map(CompoundTag.class::cast).map(SerializationHelper::deserializeItemBonus).toList();
    }

    public static List<ItemStack> getGems(ItemStack stack) {
        if (SkillTreeMod.apotheosisEnabled()) {
            return ApotheosisCompatibility.INSTANCE.getGems(stack);
        }
        if (!stack.m_41782_()) {
            return List.of();
        }
        return stack.m_41784_().m_128437_("gems", 8).stream().map(StringTag.class::cast).map(StringTag::m_7916_).map(ResourceLocation::new).map(GemTypesReloader::getGemTypeById).map(GemItem::getDefaultGemStack).toList();
    }

    @SubscribeEvent
    public static void addGemModels(ModelEvent.RegisterAdditional event) {
        Set textures = Minecraft.m_91087_().m_91098_().m_214159_("models", l -> "skilltree".equals(l.m_135827_()) && l.m_135815_().contains("/gems/") && l.m_135815_().endsWith(".json")).keySet();
        textures.stream().map(l -> l.m_135815_().substring("models/".length(), l.m_135815_().length() - ".json".length())).map(path -> new ResourceLocation("skilltree", path)).forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    @SubscribeEvent
    public static void replaceGemModel(ModelEvent.BakingCompleted event) {
        ModelResourceLocation model = new ModelResourceLocation(new ResourceLocation("skilltree", "gem"), "inventory");
        BakedModel oldModel = (BakedModel)event.getModels().get(model);
        if (oldModel != null) {
            event.getModels().put(model, new GemModel(oldModel, event.getModelBakery()));
        }
    }
}

