/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.data.generation.loot;

import com.google.common.collect.Maps;
import daripher.skilltree.data.generation.PSTGemTypesProvider;
import daripher.skilltree.item.gem.GemType;
import daripher.skilltree.item.gem.loot.GemLootPoolEntry;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import org.jetbrains.annotations.NotNull;

public class PSTBlockLoot
extends BlockLoot {
    private final Map<ResourceLocation, LootTable.Builder> lootTables = Maps.newHashMap();
    private final PSTGemTypesProvider gemTypesProvider;

    public PSTBlockLoot(PSTGemTypesProvider gemTypesProvider) {
        this.gemTypesProvider = gemTypesProvider;
    }

    protected void addTables() {
        this.lootTables.put(new ResourceLocation("skilltree", "gems"), this.gemsLootTable());
        this.lootTables.put(new ResourceLocation("skilltree", "apotheosis_gems"), this.apotheosisGemsLootTable());
    }

    protected LootTable.Builder gemsLootTable() {
        LootPool.Builder lootPool = LootPool.m_79043_();
        this.gemTypesProvider.getGemTypes().values().forEach(gemType -> lootPool.m_79076_((LootPoolEntryContainer.Builder)new GemLootPoolEntry.Builder(gemType.id())));
        return LootTable.m_79147_().m_79161_(lootPool);
    }

    protected LootTable.Builder apotheosisGemsLootTable() {
        LootPool.Builder lootPool = LootPool.m_79043_();
        this.gemTypesProvider.getGemTypes().values().stream().map(GemType::id).filter(id -> !id.m_135815_().contains("vacucite") && !id.m_135815_().contains("iriscite")).forEach(id -> lootPool.m_79076_((LootPoolEntryContainer.Builder)new GemLootPoolEntry.Builder((ResourceLocation)id)));
        return LootTable.m_79147_().m_79161_(lootPool);
    }

    public void accept(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        this.addTables();
        this.lootTables.forEach(consumer);
    }
}

