/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.client.widget.skill.SkillButton;
import daripher.skilltree.client.widget.skill.SkillConnection;
import daripher.skilltree.skill.PassiveSkillTree;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScreenHelper {
    public static void drawCenteredOutlinedText(PoseStack poseStack, String text, int x, int y, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92883_(poseStack, text, (float)((x -= font.m_92895_(text) / 2) + 1), (float)y, 0);
        font.m_92883_(poseStack, text, (float)(x - 1), (float)y, 0);
        font.m_92883_(poseStack, text, (float)x, (float)(y + 1), 0);
        font.m_92883_(poseStack, text, (float)x, (float)(y - 1), 0);
        font.m_92883_(poseStack, text, (float)x, (float)y, color);
    }

    public static void drawRectangle(PoseStack poseStack, int x, int y, int width, int height, int color) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)color);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)color);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)color);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)color);
    }

    public static void prepareTextureRendering(ResourceLocation textureLocation) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
    }

    public static float getAngleBetweenButtons(Button button1, Button button2) {
        float x1 = (float)button1.f_93620_ + (float)button1.m_5711_() / 2.0f;
        float y1 = (float)button1.f_93621_ + (float)button1.m_93694_() / 2.0f;
        float x2 = (float)button2.f_93620_ + (float)button2.m_5711_() / 2.0f;
        float y2 = (float)button2.f_93621_ + (float)button2.m_93694_() / 2.0f;
        return (float)Mth.m_14136_((double)(y2 - y1), (double)(x2 - x1));
    }

    public static float getDistanceBetweenButtons(Button button1, Button button2) {
        float x1 = (float)button1.f_93620_ + (float)button1.m_5711_() / 2.0f;
        float y1 = (float)button1.f_93621_ + (float)button1.m_93694_() / 2.0f;
        float x2 = (float)button2.f_93620_ + (float)button2.m_5711_() / 2.0f;
        float y2 = (float)button2.f_93621_ + (float)button2.m_93694_() / 2.0f;
        return Mth.m_14116_((float)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    }

    public static void renderSkillTooltip(PassiveSkillTree skillTree, SkillButton button, PoseStack poseStack, float x, float y, int width, int height) {
        int partWidth;
        Font font = Minecraft.m_91087_().f_91062_;
        int maxWidth = width - 10;
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        for (MutableComponent component : button.getTooltip(skillTree)) {
            if (font.m_92852_((FormattedText)component) > maxWidth) {
                tooltip.addAll(TooltipHelper.split(component, font, maxWidth));
                continue;
            }
            tooltip.add(component);
        }
        if (tooltip.isEmpty()) {
            return;
        }
        int tooltipWidth = 0;
        int tooltipHeight = tooltip.size() == 1 ? 8 : 10;
        for (MutableComponent component : tooltip) {
            int k = font.m_92852_((FormattedText)component);
            if (k > tooltipWidth) {
                tooltipWidth = k;
            }
            Objects.requireNonNull(font);
            tooltipHeight += 9 + 2;
        }
        tooltipWidth += 42;
        float tooltipX = x + 12.0f;
        float tooltipY = y - 12.0f;
        if (tooltipX + (float)tooltipWidth > (float)width) {
            tooltipX -= (float)(28 + tooltipWidth);
        }
        if (tooltipY + (float)tooltipHeight + 6.0f > (float)height) {
            tooltipY = height - tooltipHeight - 6;
        }
        if (tooltipX < 5.0f) {
            tooltipX = 5.0f;
        }
        if (tooltipY < 5.0f) {
            tooltipY = 5.0f;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)tooltipX, (double)tooltipY, 0.0);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        float zOffset = itemRenderer.f_115093_;
        itemRenderer.f_115093_ = 400.0f;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)1, (int)4, (int)(tooltipWidth - 1), (int)(tooltipHeight + 4), (int)-587202560);
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85837_(0.0, 0.0, 400.0);
        int textX = 5;
        int textY = 2;
        ScreenHelper.prepareTextureRendering(button.skill.getTooltipFrameTexture());
        GuiComponent.m_93133_((PoseStack)poseStack, (int)-4, (int)-4, (float)0.0f, (float)0.0f, (int)21, (int)20, (int)110, (int)20);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(tooltipWidth + 4 - 21), (int)-4, (float)-21.0f, (float)0.0f, (int)21, (int)20, (int)110, (int)20);
        int centerX = 17;
        for (int centerWidth = tooltipWidth + 8 - 42; centerWidth > 0; centerWidth -= partWidth) {
            partWidth = Math.min(centerWidth, 68);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)centerX, (int)-4, (float)21.0f, (float)0.0f, (int)partWidth, (int)20, (int)110, (int)20);
            centerX += partWidth;
        }
        MutableComponent title = (MutableComponent)tooltip.remove(0);
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)font, (Component)title, (int)(tooltipWidth / 2), (int)textY, (int)0xFFFFFF);
        textY += 19;
        for (MutableComponent component : tooltip) {
            font.m_92889_(poseStack, (Component)component, (float)textX, (float)textY, 0xFFFFFF);
            Objects.requireNonNull(font);
            textY += 9 + 2;
        }
        buffer.m_109911_();
        poseStack.m_85849_();
        itemRenderer.f_115093_ = zOffset;
    }

    public static void renderGatewayConnection(PoseStack poseStack, double x, double y, SkillConnection connection, boolean highlighted, float zoom, float animation) {
        ScreenHelper.prepareTextureRendering(new ResourceLocation("skilltree:textures/screen/long_connection.png"));
        poseStack.m_85836_();
        SkillButton button1 = connection.getFirstButton();
        SkillButton button2 = connection.getSecondButton();
        double connectionX = button1.f_93620_ + (float)button1.m_5711_() / 2.0f;
        double connectionY = button1.f_93621_ + (float)button1.m_93694_() / 2.0f;
        poseStack.m_85837_(connectionX + x, connectionY + y, 0.0);
        float rotation = ScreenHelper.getAngleBetweenButtons(button1, button2);
        poseStack.m_85845_(Vector3f.f_122227_.m_122270_(rotation));
        int length = (int)(ScreenHelper.getDistanceBetweenButtons(button1, button2) / zoom);
        poseStack.m_85841_(zoom, zoom, 1.0f);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)-8, (int)length, (int)6, (float)(-animation), (float)(highlighted ? 0.0f : 6.0f), (int)length, (int)6, (int)30, (int)12);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)2, (int)length, (int)6, (float)animation, (float)(highlighted ? 0.0f : 6.0f), (int)length, (int)6, (int)-30, (int)12);
        poseStack.m_85849_();
    }

    public static void renderOneWayConnection(PoseStack poseStack, double x, double y, SkillConnection connection, boolean highlighted, float zoom, float animation) {
        ScreenHelper.prepareTextureRendering(new ResourceLocation("skilltree:textures/screen/one_way_connection.png"));
        poseStack.m_85836_();
        SkillButton button1 = connection.getFirstButton();
        SkillButton button2 = connection.getSecondButton();
        double connectionX = button1.f_93620_ + (float)button1.m_5711_() / 2.0f;
        double connectionY = button1.f_93621_ + (float)button1.m_93694_() / 2.0f;
        poseStack.m_85837_(connectionX + x, connectionY + y, 0.0);
        float rotation = ScreenHelper.getAngleBetweenButtons(button1, button2);
        poseStack.m_85845_(Vector3f.f_122227_.m_122270_(rotation));
        int length = (int)(ScreenHelper.getDistanceBetweenButtons(button1, button2) / zoom);
        poseStack.m_85841_(zoom, zoom, 1.0f);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)-3, (int)length, (int)6, (float)(-animation), (float)(highlighted ? 0.0f : 6.0f), (int)length, (int)6, (int)30, (int)12);
        poseStack.m_85849_();
    }

    public static void renderConnection(PoseStack poseStack, double x, double y, SkillConnection connection, float zoom, float animation) {
        boolean shouldAnimate;
        ScreenHelper.prepareTextureRendering(new ResourceLocation("skilltree:textures/screen/direct_connection.png"));
        poseStack.m_85836_();
        SkillButton button1 = connection.getFirstButton();
        SkillButton button2 = connection.getSecondButton();
        double connectionX = button1.f_93620_ + (float)button1.m_5711_() / 2.0f;
        double connectionY = button1.f_93621_ + (float)button1.m_93694_() / 2.0f;
        poseStack.m_85837_(connectionX + x, connectionY + y, 0.0);
        float rotation = ScreenHelper.getAngleBetweenButtons(button1, button2);
        poseStack.m_85845_(Vector3f.f_122227_.m_122270_(rotation));
        int length = (int)ScreenHelper.getDistanceBetweenButtons(button1, button2);
        boolean highlighted = button1.skillLearned && button2.skillLearned;
        poseStack.m_85841_(1.0f, zoom, 1.0f);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)-3, (int)length, (int)6, (float)0.0f, (float)(highlighted ? 0.0f : 6.0f), (int)length, (int)6, (int)50, (int)12);
        boolean bl = shouldAnimate = button1.skillLearned && button2.canLearn || button2.skillLearned && button1.canLearn;
        if (!highlighted && shouldAnimate) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((Mth.m_14031_((float)(animation / 3.0f)) + 1.0f) / 2.0f));
            GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)-3, (int)length, (int)6, (float)0.0f, (float)0.0f, (int)length, (int)6, (int)50, (int)12);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        poseStack.m_85849_();
    }
}

