/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.quiver.QuiverItem;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@Mod.EventBusSubscriber(modid="skilltree", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public enum QuiverHud implements IGuiOverlay
{
    INSTANCE;

    private static final ResourceLocation WIDGETS_LOCATION;

    @SubscribeEvent
    public static void register(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("quiver_contents", (IGuiOverlay)INSTANCE);
    }

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Optional quiverCurio = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, ItemHelper::isQuiver);
        quiverCurio.map(SlotResult::stack).ifPresent(quiver -> this.renderArrows(gui, poseStack, partialTick, screenWidth, screenHeight, (ItemStack)quiver, player));
    }

    private void renderArrows(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight, ItemStack quiver, LocalPlayer player) {
        int slotX;
        if (!QuiverItem.containsArrows(quiver)) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
        HumanoidArm offhand = player.m_5737_().m_20828_();
        int center = screenWidth / 2;
        ItemStack arrows = QuiverItem.getArrows(quiver);
        int slotY = screenHeight - 16 - 3;
        boolean hasOffhandItem = !player.m_21206_().m_41619_();
        int arrowsCount = QuiverItem.getArrowsCount(quiver);
        if (offhand == HumanoidArm.LEFT) {
            slotX = center - 91 - 29 - (hasOffhandItem ? 29 : 0);
            gui.m_93228_(poseStack, slotX, screenHeight - 23, 24, 22, 29, 24);
        } else {
            slotX = center + 91 + (hasOffhandItem ? 29 : 0);
            gui.m_93228_(poseStack, slotX, screenHeight - 23, 53, 22, 29, 24);
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        if (offhand == HumanoidArm.LEFT) {
            slotX = center - 91 - 29 - (hasOffhandItem ? 29 : 0);
            this.renderSlot(slotX + 3, slotY, partialTick, (Player)player, arrows, 1, arrowsCount);
        } else {
            slotX = center + 91 + (hasOffhandItem ? 29 : 0);
            this.renderSlot(slotX + 10, slotY, partialTick, (Player)player, arrows, 1, arrowsCount);
        }
    }

    private void renderSlot(int x, int y, float partialTick, Player player, ItemStack stack, int slot, int count) {
        if (stack.m_41619_()) {
            return;
        }
        PoseStack posestack = RenderSystem.m_157191_();
        float f = (float)stack.m_41612_() - partialTick;
        if (f > 0.0f) {
            float f1 = 1.0f + f / 5.0f;
            posestack.m_85836_();
            posestack.m_85837_((double)(x + 8), (double)(y + 12), 0.0);
            posestack.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
            posestack.m_85837_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            RenderSystem.m_157182_();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        itemRenderer.m_174229_((LivingEntity)player, stack, x, y, slot);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        if (f > 0.0f) {
            posestack.m_85849_();
            RenderSystem.m_157182_();
        }
        itemRenderer.m_115174_(minecraft.f_91062_, stack, x, y, "" + count);
    }

    static {
        WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    }
}

