/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotPredicate;

public class EquipCurioTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("curios", "equip_curio");
    public static final EquipCurioTrigger INSTANCE = new EquipCurioTrigger();

    private EquipCurioTrigger() {
    }

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @Nonnull
    public Instance createInstance(@Nonnull JsonObject json, @Nonnull EntityPredicate.Composite playerPred, @Nonnull DeserializationContext conditions) {
        return new Instance(playerPred, ItemPredicate.m_45051_((JsonElement)json.get("item")), LocationPredicate.m_52629_((JsonElement)json.get("location")), SlotPredicate.fromJson(json.get("curios:slot")));
    }

    public void trigger(ServerPlayer player, ItemStack stack, ServerLevel world, double x, double y, double z) {
        this.m_66234_(player, instance -> instance.test(null, stack, world, x, y, z));
    }

    public void trigger(SlotContext slotContext, ServerPlayer player, ItemStack stack, ServerLevel world, double x, double y, double z) {
        this.m_66234_(player, instance -> instance.test(slotContext, stack, world, x, y, z));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final LocationPredicate location;
        private final SlotPredicate slot;

        public Instance(EntityPredicate.Composite playerPred, ItemPredicate count, LocationPredicate indexPos, SlotPredicate slot) {
            super(ID, playerPred);
            this.item = count;
            this.location = indexPos;
            this.slot = slot;
        }

        @Nonnull
        public JsonObject m_7683_(@Nonnull SerializationContext pConditions) {
            JsonObject jsonobject = super.m_7683_(pConditions);
            jsonobject.add("location", this.location.m_52616_());
            jsonobject.add("item", this.item.m_45048_());
            jsonobject.add("curios:slot", this.slot.serializeToJson());
            return jsonobject;
        }

        @Nonnull
        public ResourceLocation m_7294_() {
            return ID;
        }

        boolean test(SlotContext slotContext, ItemStack stack, ServerLevel world, double x, double y, double z) {
            if (this.slot != null && slotContext != null && !this.slot.matches(slotContext)) {
                return false;
            }
            return this.item.m_45049_(stack) && this.location.m_52617_(world, x, y, z);
        }
    }
}

