/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import net.minecraft.resources.ResourceLocation;

public final class SlotTypeMessage {
    public static final String REGISTER_TYPE = "register_type";
    public static final String MODIFY_TYPE = "modify_type";
    private final String identifier;
    private final Integer priority;
    private final int size;
    private final boolean visible;
    private final boolean cosmetic;
    private final ResourceLocation icon;

    private SlotTypeMessage(Builder builder) {
        this.identifier = builder.identifier;
        this.priority = builder.priority;
        this.size = builder.size;
        this.visible = builder.visible;
        this.cosmetic = builder.cosmetic;
        this.icon = builder.icon;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public int getSize() {
        return this.size;
    }

    @Deprecated
    public boolean isLocked() {
        return this.getSize() == 0;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean hasCosmetic() {
        return this.cosmetic;
    }

    public static class Builder {
        private final String identifier;
        private Integer priority;
        private int size = 1;
        private boolean visible = true;
        private boolean cosmetic = false;
        private ResourceLocation icon = null;

        public Builder(String identifier) {
            this.identifier = identifier;
        }

        public Builder icon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        @Deprecated
        public Builder lock() {
            this.size = 0;
            return this;
        }

        public Builder hide() {
            this.visible = false;
            return this;
        }

        public Builder cosmetic() {
            this.cosmetic = true;
            return this;
        }

        public SlotTypeMessage build() {
            return new SlotTypeMessage(this);
        }
    }
}

