/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.processor;

import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GlowstonePortalAgeProcessor
extends StructureProcessor {
    public static final Codec<GlowstonePortalAgeProcessor> CODEC = Codec.FLOAT.fieldOf("mossiness").xmap(GlowstonePortalAgeProcessor::new, codec -> Float.valueOf(codec.mossiness)).codec();
    private final float mossiness;

    public GlowstonePortalAgeProcessor(float mossiness) {
        this.mossiness = mossiness;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos otherPos, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        RandomSource random = settings.m_230326_(relativeBlockInfo.f_74675_);
        BlockState originalState = relativeBlockInfo.f_74676_;
        BlockPos blockPos = relativeBlockInfo.f_74675_;
        BlockState newState = null;
        if (!originalState.m_60713_(Blocks.f_50652_)) {
            if (originalState.m_60713_(Blocks.f_50157_)) {
                newState = this.maybeReplaceStairs(random, relativeBlockInfo.f_74676_);
            } else if (originalState.m_60713_(Blocks.f_50409_)) {
                newState = this.maybeReplaceSlab(random, relativeBlockInfo.f_74676_);
            } else if (originalState.m_60713_(Blocks.f_50274_)) {
                newState = this.maybeReplaceWall(random, relativeBlockInfo.f_74676_);
            }
        } else {
            newState = this.maybeReplaceFullStoneBlock(random);
        }
        return newState != null ? new StructureTemplate.StructureBlockInfo(blockPos, newState, relativeBlockInfo.f_74677_) : relativeBlockInfo;
    }

    @Nullable
    private BlockState maybeReplaceFullStoneBlock(RandomSource random) {
        return random.m_188501_() < this.mossiness ? Blocks.f_50079_.m_49966_() : null;
    }

    @Nullable
    private BlockState maybeReplaceStairs(RandomSource random, BlockState state) {
        return random.m_188501_() < this.mossiness ? Blocks.f_50633_.m_152465_(state) : null;
    }

    @Nullable
    private BlockState maybeReplaceSlab(RandomSource random, BlockState state) {
        return random.m_188501_() < this.mossiness ? Blocks.f_50647_.m_152465_(state) : null;
    }

    @Nullable
    private BlockState maybeReplaceWall(RandomSource random, BlockState state) {
        return random.m_188501_() < this.mossiness ? Blocks.f_50275_.m_152465_(state) : null;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)AetherStructureProcessors.GLOWSTONE_PORTAL_AGE.get();
    }
}

