/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.weapon;

import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.HammerProjectileLaunchPacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;

public class HammerProjectile
extends ThrowableProjectile {
    private static final EntityDataAccessor<Boolean> DATA_JEB_ID = SynchedEntityData.m_135353_(HammerProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksInAir = 0;

    public HammerProjectile(EntityType<? extends HammerProjectile> type, Level level) {
        super(type, level);
    }

    public HammerProjectile(LivingEntity owner, Level level) {
        super((EntityType)AetherEntityTypes.HAMMER_PROJECTILE.get(), owner, level);
    }

    public HammerProjectile(Level level) {
        super((EntityType)AetherEntityTypes.HAMMER_PROJECTILE.get(), level);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_JEB_ID, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20096_()) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir > 500 && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void shoot(float rotationPitch, float rotationYaw, float velocity, float inaccuracy) {
        float x = -Mth.m_14031_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(rotationPitch * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        super.m_6686_((double)x, (double)y, (double)z, velocity, inaccuracy);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        if (!this.m_9236_().m_5776_()) {
            this.launchTarget(target);
            this.m_9236_().m_7605_((Entity)this, (byte)70);
        } else {
            PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new HammerProjectileLaunchPacket(target.m_19879_(), this.m_19879_()));
            this.spawnParticles();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(5.0));
        for (Entity target : list) {
            if (!this.m_9236_().m_5776_()) {
                this.launchTarget(target);
                continue;
            }
            PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new HammerProjectileLaunchPacket(target.m_19879_(), this.m_19879_()));
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)70);
        } else {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        for (int j = 0; j < 8; ++j) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void launchTarget(Entity target) {
        if (target != this.m_37282_() && (this.m_37282_() == null || target != this.m_37282_().m_20202_()) && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 7.0f);
            livingEntity.m_5997_(this.m_20184_().m_7096_(), 0.6, this.m_20184_().m_7094_());
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void setIsJeb(boolean isJeb) {
        this.m_20088_().m_135381_(DATA_JEB_ID, (Object)isJeb);
    }

    public boolean getIsJeb() {
        return (Boolean)this.m_20088_().m_135370_(DATA_JEB_ID);
    }

    public void m_7822_(byte id) {
        if (id == 70) {
            this.spawnParticles();
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TicksInAir", this.ticksInAir);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("TicksInAir")) {
            this.ticksInAir = tag.m_128451_("TicksInAir");
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

