/*
 * Decompiled with CFR 0.152.
 */
package io.github.derringersmods.toomanyglyphs.common.network;

import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import io.github.derringersmods.toomanyglyphs.common.network.AbstractPacketHandler;
import io.github.derringersmods.toomanyglyphs.common.network.NetworkUtil;
import io.github.derringersmods.toomanyglyphs.init.TooManyGlyphsNetworking;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketRayEffect {
    public Vec3 from;
    public Vec3 to;
    public ParticleColor color;

    public PacketRayEffect(Vec3 from, Vec3 to, ParticleColor colors) {
        this.from = from;
        this.to = to;
        this.color = colors;
    }

    public static void encode(PacketRayEffect msg, FriendlyByteBuf buf) {
        NetworkUtil.encode(buf, msg.from);
        NetworkUtil.encode(buf, msg.to);
        NetworkUtil.encode(buf, msg.color);
    }

    public static PacketRayEffect decode(FriendlyByteBuf buf) {
        Vec3 from = NetworkUtil.decodeVector3d(buf);
        Vec3 to = NetworkUtil.decodeVector3d(buf);
        ParticleColor color = NetworkUtil.decodeParticleColor(buf);
        return new PacketRayEffect(from, to, color);
    }

    public static void handle(PacketRayEffect msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            ctx.enqueueWork(() -> NetworkUtil.getClientHandlerFor(PacketRayEffect.class).accept(msg, ctx));
        }
        ctx.setPacketHandled(true);
    }

    public static void send(@Nonnull Level level, @Nonnull SpellContext spellContext, @Nonnull Vec3 fromPoint, @Nonnull Vec3 hitPoint) {
        Vec3 midpoint = fromPoint.m_82549_(hitPoint).m_82490_(0.5);
        double radius = 64.0 + fromPoint.m_82554_(midpoint);
        double radiusSqr = radius * radius;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketRayEffect fx = new PacketRayEffect(fromPoint, hitPoint, spellContext.getColors());
            serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(new BlockPos(midpoint)), false).stream().filter(p -> p.m_20238_(midpoint) <= radiusSqr).forEach(p -> TooManyGlyphsNetworking.fxChannel.send(PacketDistributor.PLAYER.with(() -> p), (Object)fx));
        }
    }

    public static class ClientHandler
    extends AbstractPacketHandler<PacketRayEffect> {
        @Override
        public void accept(PacketRayEffect msg, NetworkEvent.Context context) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null) {
                return;
            }
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                return;
            }
            double distance = msg.from.m_82554_(msg.to);
            double start = 0.0;
            double increment = 0.0625;
            if (player.m_20182_().m_82557_(msg.from) < 4.0 && msg.to.m_82546_(msg.from).m_82541_().m_82526_(player.m_20252_(1.0f)) > (double)(Mth.f_13994_ / 2.0f)) {
                start = Math.min(2.0, distance / 2.0);
                increment = 0.125;
            }
            for (double d = start; d < distance; d += increment) {
                double fractionalDistance = d / distance;
                double speedCoefficient = Mth.m_14139_((double)fractionalDistance, (double)0.2, (double)0.001);
                level.m_7106_(GlowParticleData.createData((ParticleColor)msg.color), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82479_, (double)msg.to.f_82479_), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82480_, (double)msg.to.f_82480_), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82481_, (double)msg.to.f_82481_), ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient);
            }
        }
    }
}

